/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.data.GeneratedPOJO;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

class FileSystemPersistenceGeneratorTest {
    private static final String TEST_RESOURCES = "src/test/resources";
    KogitoBuildContext context = QuarkusKogitoBuildContext.builder().withApplicationProperties(new File[]{new File("src/test/resources")}).withPackageName(this.getClass().getPackage().getName()).withAddonsConfig(AddonsConfig.builder().withPersistence(true).build()).build();

    FileSystemPersistenceGeneratorTest() {
    }

    @Test
    void test() {
        this.context.setApplicationProperty("kogito.persistence.type", (Object)"filesystem");
        ReflectionProtoGenerator protoGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(Collections.singleton(GeneratedPOJO.class));
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(this.context, (ProtoGenerator)protoGenerator);
        Collection generatedFiles = persistenceGenerator.generate();
        Assertions.assertThat((long)generatedFiles.stream().filter(gf -> gf.type().equals(ProtoGenerator.PROTO_TYPE)).count()).isEqualTo(2L);
        Assertions.assertThat((long)generatedFiles.stream().filter(gf -> gf.type().equals(ProtoGenerator.PROTO_TYPE) && gf.relativePath().endsWith(".json")).count()).isEqualTo(1L);
        Assertions.assertThat((Iterable)generatedFiles).hasSize(15);
        Optional<GeneratedFile> persistenceFactoryImpl = generatedFiles.stream().filter(gf -> gf.relativePath().equals("org/kie/kogito/persistence/KogitoProcessInstancesFactoryImpl.java")).findFirst();
        Assertions.assertThat(persistenceFactoryImpl).isNotEmpty();
        CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(persistenceFactoryImpl.get().contents()));
        ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
        Optional methodDeclaration = classDeclaration.findFirst(MethodDeclaration.class, d -> d.getName().getIdentifier().equals("path"));
        Assertions.assertThat((Optional)methodDeclaration).isNotEmpty();
        Optional fieldDeclaration = classDeclaration.findFirst(FieldDeclaration.class);
        Assertions.assertThat((Optional)fieldDeclaration).isNotEmpty();
        Assertions.assertThat((List)((FieldDeclaration)fieldDeclaration.get()).getVariables()).hasSize(1);
        Assertions.assertThat((String)((VariableDeclarator)((FieldDeclaration)fieldDeclaration.get()).getVariables().get(0)).getName().asString()).isEqualTo("path");
    }
}

