/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

class MongoDBPersistenceGeneratorTest {
    private static final String TEST_RESOURCES = "src/test/resources";
    private static final String PERSISTENCE_FILE_PATH = "org/kie/kogito/persistence/KogitoProcessInstancesFactoryImpl.java";
    private static final String TRANSACTION_FILE_PATH = "org/kie/kogito/mongodb/transaction/MongoDBTransactionManagerImpl.java";
    KogitoBuildContext context = QuarkusKogitoBuildContext.builder().withApplicationProperties(new File[]{new File("src/test/resources")}).withPackageName(this.getClass().getPackage().getName()).withAddonsConfig(AddonsConfig.builder().withPersistence(true).build()).build();

    MongoDBPersistenceGeneratorTest() {
    }

    @Test
    void test() {
        this.context.setApplicationProperty("kogito.persistence.type", (Object)"mongodb");
        ReflectionProtoGenerator protoGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(Collections.singleton(Person.class));
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(this.context, (ProtoGenerator)protoGenerator);
        Collection generatedFiles = persistenceGenerator.generate();
        Optional<GeneratedFile> generatedCLASSFile = generatedFiles.stream().filter(gf -> gf.category() == GeneratedFileType.SOURCE.category()).filter(f -> PERSISTENCE_FILE_PATH.equals(f.relativePath())).findAny();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedCLASSFile.isPresent());
        GeneratedFile classFile = generatedCLASSFile.get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)PERSISTENCE_FILE_PATH, (Object)classFile.relativePath());
        CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(classFile.contents()));
        ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)classDeclaration);
        MethodDeclaration methodDeclaration = (MethodDeclaration)classDeclaration.findFirst(MethodDeclaration.class, d -> d.getName().getIdentifier().equals("dbName")).orElseThrow(() -> new NoSuchElementException("Class declaration doesn't contain a method named \"dbName\"!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)methodDeclaration);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)methodDeclaration.getBody().isPresent());
        BlockStmt body = (BlockStmt)methodDeclaration.getBody().get();
        Assertions.assertThat((int)body.getStatements().size()).isOne();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Statement)body.getStatements().get(0)).isReturnStmt());
        ReturnStmt returnStmt = (ReturnStmt)body.getStatements().get(0);
        Assertions.assertThat((String)returnStmt.toString()).contains(new CharSequence[]{"kogito"});
        MethodDeclaration transactionMethodDeclaration = (MethodDeclaration)classDeclaration.findFirst(MethodDeclaration.class, d -> "transactionManager".equals(d.getName().getIdentifier())).orElseThrow(() -> new NoSuchElementException("Class declaration doesn't contain a method named \"transactionManager\"!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)transactionMethodDeclaration);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)transactionMethodDeclaration.getBody().isPresent());
        BlockStmt transactionMethodBody = (BlockStmt)transactionMethodDeclaration.getBody().get();
        Assertions.assertThat((int)transactionMethodBody.getStatements().size()).isOne();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Statement)transactionMethodBody.getStatements().get(0)).isReturnStmt());
        ReturnStmt transactionReturnStmt = (ReturnStmt)transactionMethodBody.getStatements().get(0);
        Assertions.assertThat((String)transactionReturnStmt.toString()).contains(new CharSequence[]{"transactionManager"});
        Optional<GeneratedFile> generatedTransactionCLASSFile = generatedFiles.stream().filter(gf -> gf.category() == GeneratedFileType.SOURCE.category()).filter(f -> TRANSACTION_FILE_PATH.equals(f.relativePath())).findAny();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedTransactionCLASSFile.isPresent());
        CompilationUnit transactionCompilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(generatedTransactionCLASSFile.get().contents()));
        ClassOrInterfaceDeclaration transactionClassDeclaration = (ClassOrInterfaceDeclaration)transactionCompilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)transactionClassDeclaration);
        List constructorDeclarations = transactionCompilationUnit.findAll(ConstructorDeclaration.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)constructorDeclarations.size());
        Optional<ConstructorDeclaration> annotatedConstructorDeclaration = constructorDeclarations.stream().filter(c -> c.isAnnotationPresent("Inject")).findAny();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)annotatedConstructorDeclaration.isPresent());
        MethodDeclaration transactionEnabledMethodDeclaration = (MethodDeclaration)transactionClassDeclaration.findFirst(MethodDeclaration.class, d -> d.getName().getIdentifier().equals("enabled")).orElseThrow(() -> new NoSuchElementException("Class declaration doesn't contain a method named \"enabled\"!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)transactionEnabledMethodDeclaration);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)transactionEnabledMethodDeclaration.getBody().isPresent());
        BlockStmt enabledMethodBody = (BlockStmt)transactionEnabledMethodDeclaration.getBody().get();
        Assertions.assertThat((int)enabledMethodBody.getStatements().size()).isOne();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Statement)enabledMethodBody.getStatements().get(0)).isReturnStmt());
        ReturnStmt enabledReturnStmt = (ReturnStmt)enabledMethodBody.getStatements().get(0);
        Assertions.assertThat((String)enabledReturnStmt.toString()).contains(new CharSequence[]{"enabled"});
        FieldDeclaration transactionEnabledFieldDeclaration = (FieldDeclaration)transactionClassDeclaration.findFirst(FieldDeclaration.class, f -> f.getVariable(0).getName().getIdentifier().equals("enabled")).orElseThrow(() -> new NoSuchElementException("Class declaration doesn't contain a field named \"enabled\"!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)transactionEnabledFieldDeclaration);
        NormalAnnotationExpr transactionEnabledAnnotationDeclaration = (NormalAnnotationExpr)transactionEnabledFieldDeclaration.findFirst(NormalAnnotationExpr.class, a -> ((Name)a.getChildNodes().get(0)).getIdentifier().equals("ConfigProperty")).orElseThrow(() -> new NoSuchElementException("Field declaration doesn't contain an annotation  named \"ConfigProperty\"!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)transactionEnabledAnnotationDeclaration);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"kogito.persistence.transaction.enabled", (Object)((StringLiteralExpr)((Node)transactionEnabledAnnotationDeclaration.getChildNodes().get(1)).getChildNodes().get(1)).getValue());
    }
}

