/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.data.GeneratedPOJO;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

class PostgrePersistenceGeneratorTest {
    private static final String TEST_RESOURCES = "src/test/resources";
    KogitoBuildContext context = QuarkusKogitoBuildContext.builder().withApplicationProperties(new File[]{new File("src/test/resources")}).withPackageName(this.getClass().getPackage().getName()).withAddonsConfig(AddonsConfig.builder().withPersistence(true).build()).build();

    PostgrePersistenceGeneratorTest() {
    }

    @Test
    void testGeneratedFiles() {
        this.context.setApplicationProperty("kogito.persistence.type", (Object)"postgresql");
        ReflectionProtoGenerator protoGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(Collections.singleton(GeneratedPOJO.class));
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(this.context, (ProtoGenerator)protoGenerator);
        Collection generatedFiles = persistenceGenerator.generate();
        Assertions.assertThat((Iterable)generatedFiles).hasSize(16);
        Optional<GeneratedFile> persistenceFactoryImpl = generatedFiles.stream().filter(gf -> gf.relativePath().equals("org/kie/kogito/persistence/KogitoProcessInstancesFactoryImpl.java")).findFirst();
        Assertions.assertThat(persistenceFactoryImpl).isPresent();
        this.validateClassInCompilationUnit(persistenceFactoryImpl.get().contents());
        Optional<GeneratedFile> pgClientProducer = generatedFiles.stream().filter(gf -> gf.relativePath().equals("org/kie/kogito/persistence/PgClientProducer.java")).findFirst();
        Assertions.assertThat(pgClientProducer).isPresent();
        this.validateClassInCompilationUnit(pgClientProducer.get().contents());
    }

    private void validateClassInCompilationUnit(byte[] contents) {
        CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(contents));
        compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
    }
}

