/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.kogito.rest.quarkus;

import java.io.Serializable;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbTransient;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.internal.builder.InternalMessage;

public class DMNMessageSQ
implements Serializable,
DMNMessage {
    @JsonbProperty(value="dmn-message-severity")
    private DMNMessageSeverityKS severity;
    @JsonbProperty(value="message")
    private String message;
    @JsonbProperty(value="message-type")
    private DMNMessageType messageType;
    @JsonbProperty(value="source-id")
    private String sourceId;

    public static DMNMessageSQ of(DMNMessage value) {
        DMNMessageSQ res = new DMNMessageSQ();
        res.severity = DMNMessageSeverityKS.of(value.getSeverity());
        res.message = value.getMessage();
        res.messageType = value.getMessageType();
        res.sourceId = value.getSourceId();
        return res;
    }

    public DMNMessage.Severity getSeverity() {
        return this.severity.asSeverity();
    }

    public String getMessage() {
        return this.message;
    }

    public DMNMessageType getMessageType() {
        return this.messageType;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    @JsonbTransient
    public Throwable getException() {
        throw new UnsupportedOperationException();
    }

    @JsonbTransient
    public FEELEvent getFeelEvent() {
        throw new UnsupportedOperationException();
    }

    @JsonbTransient
    public Object getSourceReference() {
        throw new UnsupportedOperationException();
    }

    @JsonbTransient
    public String getKieBaseName() {
        throw new UnsupportedOperationException();
    }

    @JsonbTransient
    public InternalMessage setKieBaseName(String kieBaseName) {
        throw new UnsupportedOperationException();
    }

    @JsonbTransient
    public long getId() {
        throw new UnsupportedOperationException();
    }

    @JsonbTransient
    public String getPath() {
        throw new UnsupportedOperationException();
    }

    @JsonbTransient
    public int getLine() {
        throw new UnsupportedOperationException();
    }

    @JsonbTransient
    public int getColumn() {
        throw new UnsupportedOperationException();
    }

    public Message.Level getLevel() {
        switch (this.severity) {
            case ERROR: {
                return Message.Level.ERROR;
            }
            case INFO: {
                return Message.Level.INFO;
            }
            case WARN: {
                return Message.Level.WARNING;
            }
        }
        return Message.Level.ERROR;
    }

    @JsonbTransient
    public String getText() {
        throw new UnsupportedOperationException();
    }

    public static enum DMNMessageSeverityKS {
        INFO,
        WARN,
        ERROR;


        public static DMNMessageSeverityKS of(DMNMessage.Severity value) {
            switch (value) {
                case ERROR: {
                    return ERROR;
                }
                case INFO: {
                    return INFO;
                }
                case TRACE: {
                    return INFO;
                }
                case WARN: {
                    return WARN;
                }
            }
            return ERROR;
        }

        public DMNMessage.Severity asSeverity() {
            switch (this) {
                case ERROR: {
                    return DMNMessage.Severity.ERROR;
                }
                case INFO: {
                    return DMNMessage.Severity.INFO;
                }
                case WARN: {
                    return DMNMessage.Severity.WARN;
                }
            }
            return DMNMessage.Severity.ERROR;
        }
    }
}

