/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.kogito.rest.quarkus;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.json.bind.annotation.JsonbProperty;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.core.ast.ItemDefNodeImpl;
import org.kie.dmn.kogito.rest.quarkus.DMNDecisionInfo;
import org.kie.dmn.kogito.rest.quarkus.DMNDecisionServiceInfo;
import org.kie.dmn.kogito.rest.quarkus.DMNInputDataInfo;
import org.kie.dmn.kogito.rest.quarkus.DMNItemDefinitionInfo;

public class DMNModelInfo
implements Serializable {
    private String namespace;
    private String name;
    private String id;
    private Collection<DMNDecisionInfo> decisions = new HashSet<DMNDecisionInfo>();
    private Collection<DMNInputDataInfo> inputs = new HashSet<DMNInputDataInfo>();
    private Collection<DMNItemDefinitionInfo> itemDefinitions = new HashSet<DMNItemDefinitionInfo>();
    private Collection<DMNDecisionServiceInfo> decisionServices = new HashSet<DMNDecisionServiceInfo>();

    public static DMNModelInfo of(DMNModel model) {
        DMNModelInfo res = new DMNModelInfo();
        res.setNamespace(model.getNamespace());
        res.setName(model.getName());
        res.setId(model.getDefinitions().getId());
        res.setDecisions(model.getDecisions().stream().map(DMNDecisionInfo::of).collect(Collectors.toSet()));
        res.setDecisionServices(model.getDecisionServices().stream().map(DMNDecisionServiceInfo::of).collect(Collectors.toSet()));
        res.setInputs(model.getInputs().stream().map(DMNInputDataInfo::of).collect(Collectors.toSet()));
        res.setItemDefinitions(model.getItemDefinitions().stream().map(id -> DMNItemDefinitionInfo.of(((ItemDefNodeImpl)id).getItemDef())).collect(Collectors.toSet()));
        return res;
    }

    @JsonbProperty(value="model-namespace")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonbProperty(value="model-name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonbProperty(value="model-id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonbProperty(value="decisions")
    public Collection<DMNDecisionInfo> getDecisions() {
        return this.decisions;
    }

    public void setDecisions(Collection<DMNDecisionInfo> decisions) {
        this.decisions = decisions;
    }

    @JsonbProperty(value="inputs")
    public Collection<DMNInputDataInfo> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<DMNInputDataInfo> inputs) {
        this.inputs = inputs;
    }

    @JsonbProperty(value="itemDefinitions")
    public Collection<DMNItemDefinitionInfo> getItemDefinitions() {
        return this.itemDefinitions;
    }

    public void setItemDefinitions(Collection<DMNItemDefinitionInfo> itemDefinitions) {
        this.itemDefinitions = itemDefinitions;
    }

    @JsonbProperty(value="decisionServices")
    public Collection<DMNDecisionServiceInfo> getDecisionServices() {
        return this.decisionServices;
    }

    public void setDecisionServices(Collection<DMNDecisionServiceInfo> decisionServices) {
        this.decisionServices = decisionServices;
    }
}

