/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.kogito.rest.quarkus;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.ResourceTypePackageRegistry;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.kie.api.io.ResourceType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.impl.DMNPackageImpl;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.internal.utils.DMNEvaluationUtils;
import org.kie.dmn.kogito.rest.quarkus.DMNResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNKogitoQuarkus {
    private static final Logger LOG = LoggerFactory.getLogger(DMNKogitoQuarkus.class);

    private DMNKogitoQuarkus() {
    }

    public static DMNRuntime createGenericDMNRuntime() {
        KnowledgeBaseImpl knowledgeBase = new KnowledgeBaseImpl("", new RuleBaseConfiguration());
        Map pkgs = knowledgeBase.getPackagesMap();
        DMNCompilerImpl compilerImpl = new DMNCompilerImpl();
        try (Stream<Path> fileStream = Files.walk(Paths.get(".", new String[0]), new FileVisitOption[0]);){
            List files = fileStream.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".dmn")).peek(x -> LOG.debug("Adding DMN model {} to runtime", x)).collect(Collectors.toList());
            for (Path file : files) {
                DMNModel m = compilerImpl.compile((Reader)new FileReader(file.toFile()));
                InternalKnowledgePackage pkg = pkgs.computeIfAbsent(m.getNamespace(), KnowledgePackageImpl::new);
                ResourceTypePackageRegistry rpkg = pkg.getResourceTypePackages();
                DMNPackageImpl dmnpkg = (DMNPackageImpl)rpkg.computeIfAbsent(ResourceType.DMN, rtp -> new DMNPackageImpl(m.getNamespace()));
                dmnpkg.addModel(m.getName(), m);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new DMNRuntimeImpl((InternalKnowledgeBase)knowledgeBase);
    }

    public static DMNModel modelByName(DMNRuntime dmnRuntime, String modelName) {
        List modelsWithName = dmnRuntime.getModels().stream().filter(m -> modelName.equals(m.getName())).collect(Collectors.toList());
        if (modelsWithName.size() == 1) {
            return (DMNModel)modelsWithName.get(0);
        }
        throw new RuntimeException("Multiple model with the same name: " + modelName);
    }

    public static DMNResult evaluate(DMNRuntime dmnRuntime, String modelName, Map<String, Object> dmnContext) {
        return DMNKogitoQuarkus.evaluate(dmnRuntime, DMNKogitoQuarkus.modelByName(dmnRuntime, modelName).getNamespace(), modelName, dmnContext);
    }

    public static DMNResult evaluate(DMNRuntime dmnRuntime, String modelNamespace, String modelName, Map<String, Object> dmnContext) {
        DMNEvaluationUtils.DMNEvaluationResult evaluationResult = DMNEvaluationUtils.evaluate((DMNRuntime)dmnRuntime, (String)modelNamespace, (String)modelName, dmnContext, null, null, null);
        return new DMNResult(evaluationResult.result);
    }
}

