/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.util.Map;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.kogito.ExecutionIdSupplier;
import org.kie.kogito.decision.DecisionExecutionIdUtils;
import org.kie.kogito.decision.DecisionModel;

public class DmnDecisionModel
implements DecisionModel {
    private final DMNRuntime dmnRuntime;
    private final ExecutionIdSupplier execIdSupplier;
    private final DMNModel dmnModel;

    public DmnDecisionModel(DMNRuntime dmnRuntime, String namespace, String name) {
        this(dmnRuntime, namespace, name, null);
    }

    public DmnDecisionModel(DMNRuntime dmnRuntime, String namespace, String name, ExecutionIdSupplier execIdSupplier) {
        this.dmnRuntime = dmnRuntime;
        this.execIdSupplier = execIdSupplier;
        this.dmnModel = dmnRuntime.getModel(namespace, name);
        if (this.dmnModel == null) {
            throw new IllegalStateException("DMN model '" + name + "' not found with namespace '" + namespace + "' in the inherent DMNRuntime.");
        }
    }

    public DMNContext newContext(Map<String, Object> variables) {
        return new DMNContextImpl(variables);
    }

    public DMNResult evaluateAll(DMNContext context) {
        return this.dmnRuntime.evaluateAll(this.dmnModel, context);
    }

    public DMNResult evaluateDecisionService(DMNContext context, String decisionServiceName) {
        return this.dmnRuntime.evaluateDecisionService(this.dmnModel, this.inject(context), decisionServiceName);
    }

    private DMNContext inject(DMNContext context) {
        return this.execIdSupplier != null ? DecisionExecutionIdUtils.inject((DMNContext)context, (ExecutionIdSupplier)this.execIdSupplier) : context;
    }

    public DMNModel getDMNModel() {
        return this.dmnModel;
    }
}

