/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.core.internal.utils.MapBackedDMNContext;
import org.kie.dmn.core.internal.utils.MarshallingStubUtils;
import org.kie.kogito.dmn.rest.DMNDecisionResultSQ;
import org.kie.kogito.dmn.rest.DMNMessageSQ;

public class DMNResult
implements Serializable,
org.kie.dmn.api.core.DMNResult {
    private String namespace;
    private String modelName;
    private Map<String, Object> dmnContext = new HashMap<String, Object>();
    private List<DMNMessageSQ> messages = new ArrayList<DMNMessageSQ>();
    private Map<String, DMNDecisionResultSQ> decisionResults = new HashMap<String, DMNDecisionResultSQ>();

    public DMNResult() {
    }

    public DMNResult(String namespace, String modelName, org.kie.dmn.api.core.DMNResult dmnResult) {
        this.namespace = namespace;
        this.modelName = modelName;
        this.setDmnContext(dmnResult.getContext().getAll());
        this.setMessages(dmnResult.getMessages());
        this.setDecisionResults(dmnResult.getDecisionResults());
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Map<String, Object> getDmnContext() {
        return this.dmnContext;
    }

    public void setDmnContext(Map<String, Object> dmnContext) {
        this.dmnContext = new HashMap<String, Object>();
        for (Map.Entry<String, Object> kv : dmnContext.entrySet()) {
            this.dmnContext.put(kv.getKey(), MarshallingStubUtils.stubDMNResult((Object)kv.getValue(), String::valueOf));
        }
    }

    public void setMessages(List<DMNMessage> messages) {
        for (DMNMessage m : messages) {
            this.messages.add(DMNMessageSQ.of(m));
        }
    }

    public void setDecisionResults(List<? extends DMNDecisionResult> decisionResults) {
        for (DMNDecisionResult dMNDecisionResult : decisionResults) {
            this.decisionResults.put(dMNDecisionResult.getDecisionId(), DMNDecisionResultSQ.of(dMNDecisionResult));
        }
    }

    @JsonIgnore
    public DMNContext getContext() {
        return MapBackedDMNContext.of(this.dmnContext);
    }

    public List<DMNMessage> getMessages() {
        return this.messages;
    }

    public List<DMNMessage> getMessages(DMNMessage.Severity ... sevs) {
        return this.messages.stream().filter(m -> Arrays.asList(sevs).stream().anyMatch(f -> f.equals((Object)m.getSeverity()))).collect(Collectors.toList());
    }

    public boolean hasErrors() {
        return this.messages.stream().anyMatch(m -> DMNMessage.Severity.ERROR.equals((Object)m.getSeverity()));
    }

    public List<DMNDecisionResult> getDecisionResults() {
        return new ArrayList<DMNDecisionResult>(this.decisionResults.values());
    }

    public DMNDecisionResult getDecisionResultByName(String name) {
        return this.decisionResults.values().stream().filter(dr -> dr.getDecisionName().equals(name)).findFirst().get();
    }

    public DMNDecisionResult getDecisionResultById(String id) {
        return this.decisionResults.get(id);
    }

    public String toString() {
        return "DMNResultKS [" + "namespace=" + this.namespace + ", modelName=" + this.modelName + ", dmnContext=" + this.dmnContext + ", messages=" + this.messages + ", decisionResults=" + this.decisionResults + "]";
    }
}

