/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.function.Function;
import org.drools.core.util.IoUtils;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.kie.kogito.Application;
import org.kie.kogito.ExecutionIdSupplier;
import org.kie.kogito.decision.DecisionConfig;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.DMNKogito;
import org.kie.kogito.dmn.DmnDecisionModel;

public abstract class AbstractDecisionModels
implements DecisionModels {
    private static final boolean CAN_PLATFORM_CLASSLOAD = ClassLoaderUtil.CAN_PLATFORM_CLASSLOAD;
    private static DMNRuntime dmnRuntime = null;
    private static ExecutionIdSupplier execIdSupplier = null;
    private static Function<DecisionModel, DecisionModel> decisionModelTransformer = null;

    protected static void init(Function<String, KieRuntimeFactory> sKieRuntimeFactoryFunction, ExecutionIdSupplier executionIdSupplier, Function<DecisionModel, DecisionModel> decisionModelTransformerInit, Reader ... readers) {
        dmnRuntime = DMNKogito.createGenericDMNRuntime(sKieRuntimeFactoryFunction, readers);
        execIdSupplier = executionIdSupplier;
        decisionModelTransformer = decisionModelTransformerInit;
    }

    public DecisionModel getDecisionModel(String namespace, String name) {
        DmnDecisionModel model = new DmnDecisionModel(dmnRuntime, namespace, name, execIdSupplier);
        return decisionModelTransformer == null ? model : decisionModelTransformer.apply(model);
    }

    public AbstractDecisionModels() {
    }

    public AbstractDecisionModels(Application app) {
        this.initApplication(app);
    }

    protected void initApplication(Application app) {
        ((DecisionConfig)app.config().get(DecisionConfig.class)).decisionEventListeners().listeners().forEach(arg_0 -> ((DMNRuntime)dmnRuntime).addListener(arg_0));
    }

    protected static InputStreamReader readResource(InputStream stream) {
        if (CAN_PLATFORM_CLASSLOAD) {
            return new InputStreamReader(stream);
        }
        try {
            byte[] bytes = IoUtils.readBytesFromInputStream((InputStream)stream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return new InputStreamReader(byteArrayInputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

