/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.kie.api.management.GAV;
import org.kie.kogito.decision.DecisionModelMetadata;
import org.kie.kogito.decision.DecisionModelResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecisionModelResource
implements DecisionModelResource {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDecisionModelResource.class);
    private final GAV gav;
    private final String namespace;
    private final String modelName;
    private final DecisionModelMetadata type;
    private final InputStreamReader resourceReader;

    public DefaultDecisionModelResource(GAV gav, String namespace, String modelName, DecisionModelMetadata type, InputStreamReader resourceReader) {
        this.gav = gav;
        this.namespace = namespace;
        this.modelName = modelName;
        this.type = type;
        this.resourceReader = resourceReader;
    }

    public GAV getGav() {
        return this.gav;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getModelName() {
        return this.modelName;
    }

    public DecisionModelMetadata getModelMetadata() {
        return this.type;
    }

    public String get() {
        return this.load();
    }

    private String load() {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader isr = this.resourceReader;
             BufferedReader reader = new BufferedReader(isr);){
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = reader.readLine();
            }
        }
        catch (IOException ioe) {
            LOG.error(ioe.getMessage());
            throw new RuntimeException(ioe);
        }
        return sb.toString();
    }
}

