/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.io.Reader;
import java.util.function.Function;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.kogito.ExecutionIdSupplier;
import org.kie.kogito.decision.DecisionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DMNKogitoCallbacks {
    private static final Logger LOG = LoggerFactory.getLogger(DMNKogitoCallbacks.class);

    private DMNKogitoCallbacks() {
    }

    public static void beforeCreateGenericDMNRuntime(Function<String, KieRuntimeFactory> kiePMMLRuntimeFactoryFunction, Reader[] readers) {
        if (DMNKogitoCallbacks.isGraalVMNIRuntime()) {
            LOG.warn("createGenericDMNRuntime with {} model(s) for DMNRuntime initialization...", (Object)readers.length);
        } else {
            LOG.debug("createGenericDMNRuntime with {} model(s) for DMNRuntime initialization...", (Object)readers.length);
        }
    }

    public static void afterCreateGenericDMNRuntime(DMNRuntime dmnRuntime) {
        if (DMNKogitoCallbacks.isGraalVMNIRuntime()) {
            LOG.warn("createGenericDMNRuntime done. DMNRuntime contains {} DMNModel(s).", (Object)dmnRuntime.getModels().size());
        } else {
            LOG.debug("createGenericDMNRuntime done. DMNRuntime contains {} DMNModel(s).", (Object)dmnRuntime.getModels().size());
        }
    }

    public static void beforeAbstractDecisionModelsInit(Function<String, KieRuntimeFactory> sKieRuntimeFactoryFunction, ExecutionIdSupplier executionIdSupplier, Function<DecisionModel, DecisionModel> decisionModelTransformerInit, Reader[] readers) {
        if (DMNKogitoCallbacks.isGraalVMNIRuntime()) {
            LOG.warn("AbstractDecisionModels.init() called.");
        } else {
            LOG.debug("AbstractDecisionModels.init() called.");
        }
    }

    public static void afterAbstractDecisionModelsInit(DMNRuntime dmnRuntime) {
        if (DMNKogitoCallbacks.isGraalVMNIRuntime()) {
            LOG.warn("AbstractDecisionModels.init() done.");
        } else {
            LOG.debug("AbstractDecisionModels.init() done.");
        }
    }

    private static boolean isGraalVMNIRuntime() {
        return "runtime".equals(System.getProperty("org.graalvm.nativeimage.imagecode"));
    }
}

