/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.FEELPropertyAccessible;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.impl.DMNContextFPAImpl;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.kogito.ExecutionIdSupplier;
import org.kie.kogito.decision.DecisionExecutionIdUtils;
import org.kie.kogito.decision.DecisionModel;

public class DmnDecisionModel
implements DecisionModel {
    private final DMNRuntime dmnRuntime;
    private final ExecutionIdSupplier execIdSupplier;
    private final DMNModel dmnModel;

    public DmnDecisionModel(DMNRuntime dmnRuntime, String namespace, String name) {
        this(dmnRuntime, namespace, name, null);
    }

    public DmnDecisionModel(DMNRuntime dmnRuntime, String namespace, String name, ExecutionIdSupplier execIdSupplier) {
        this.dmnRuntime = dmnRuntime;
        this.execIdSupplier = execIdSupplier;
        this.dmnModel = dmnRuntime.getModel(namespace, name);
        if (this.dmnModel == null) {
            throw new IllegalStateException("DMN model '" + name + "' not found with namespace '" + namespace + "' in the inherent DMNRuntime.");
        }
    }

    @Override
    public DMNContext newContext(Map<String, Object> variables) {
        return new DMNContextImpl(variables != null ? variables : Collections.emptyMap());
    }

    @Override
    public DMNContext newContext(FEELPropertyAccessible inputSet) {
        return new DMNContextFPAImpl(inputSet);
    }

    @Override
    public DMNResult evaluateAll(DMNContext context) {
        return this.dmnRuntime.evaluateAll(this.dmnModel, this.injectExecutionId(context));
    }

    @Override
    public DMNResult evaluateDecisionService(DMNContext context, String decisionServiceName) {
        return this.dmnRuntime.evaluateDecisionService(this.dmnModel, this.injectExecutionId(context), decisionServiceName);
    }

    private DMNContext injectExecutionId(DMNContext context) {
        return this.execIdSupplier != null ? DecisionExecutionIdUtils.inject(context, this.execIdSupplier) : context;
    }

    @Override
    public DMNModel getDMNModel() {
        return this.dmnModel;
    }

    public List<DMNProfile> getProfiles() {
        return Collections.unmodifiableList(((DMNRuntimeImpl)this.dmnRuntime).getProfiles());
    }
}

