/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.drools.core.unit;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.event.RuleRuntimeEventSupport;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.impl.InternalRuleUnit;
import org.drools.ruleunits.impl.sessions.RuleUnitExecutorImpl;
import org.kie.kogito.Application;
import org.kie.kogito.Config;
import org.kie.kogito.rules.RuleConfig;
import org.kie.kogito.rules.RuleEventListenerConfig;
import org.kie.kogito.rules.RuleUnits;

public abstract class AbstractRuleUnits
implements RuleUnits {
    protected final Map<Class<? extends RuleUnitData>, RuleUnit<? extends RuleUnitData>> ruleUnitsMap = new HashMap<Class<? extends RuleUnitData>, RuleUnit<? extends RuleUnitData>>();
    protected final Map<String, RuleUnitInstance<?>> unitRegistry = new HashMap();

    public void register(String name, RuleUnitInstance<?> unitInstance) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot register a RuleUnitInstance with a null name");
        }
        this.unitRegistry.put(name, unitInstance);
    }

    public RuleUnitInstance<?> getRegisteredInstance(String name) {
        return this.unitRegistry.get(name);
    }

    public <T extends RuleUnitData> RuleUnit<T> create(Class<T> clazz) {
        Object unit = this.ruleUnitsMap.get(clazz);
        if (unit == null) {
            unit = this.internalCreate(clazz);
        }
        return unit;
    }

    protected abstract <T extends RuleUnitData> RuleUnit<T> internalCreate(Class<T> var1);

    protected void registerRuleUnit(Application application, InternalRuleUnit<?> unit) {
        this.ruleUnitsMap.put(unit.getRuleUnitDataClass(), (RuleUnit<? extends RuleUnitData>)unit);
        unit.setEvaluatorConfigurator(reteEvaluator -> this.configureReteEvaluator(application, (ReteEvaluator)reteEvaluator));
    }

    protected ReteEvaluator configureReteEvaluator(Application application, ReteEvaluator reteEvaluator) {
        Config config = application.config();
        if (config != null) {
            RuleEventListenerConfig ruleEventListenerConfig = ((RuleConfig)config.get(RuleConfig.class)).ruleEventListeners();
            ruleEventListenerConfig.agendaListeners().forEach(arg_0 -> ((AgendaEventSupport)reteEvaluator.getActivationsManager().getAgendaEventSupport()).addEventListener(arg_0));
            ruleEventListenerConfig.ruleRuntimeListeners().forEach(arg_0 -> ((RuleRuntimeEventSupport)reteEvaluator.getRuleRuntimeEventSupport()).addEventListener(arg_0));
        }
        ((RuleUnitExecutorImpl)reteEvaluator).setRuleUnits((org.drools.ruleunits.api.RuleUnits)this);
        return reteEvaluator;
    }
}

