/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event;

import java.util.Optional;
import org.kie.kogito.event.EventUnmarshaller;

public class SubscriptionInfo<S, T> {
    private EventUnmarshaller<S> converter;
    private Class<T> outputClass;
    private Class<?>[] parametrizedClasses;
    private Optional<String> type;

    private SubscriptionInfo(EventUnmarshaller<S> converter, Class<T> outputClass, Class<?>[] parametrizedClasses, String type) {
        this.converter = converter;
        this.outputClass = outputClass;
        this.parametrizedClasses = parametrizedClasses;
        this.type = Optional.ofNullable(type);
    }

    public Optional<String> getType() {
        return this.type;
    }

    public EventUnmarshaller<S> getConverter() {
        return this.converter;
    }

    public Class<T> getOutputClass() {
        return this.outputClass;
    }

    public Class<?>[] getParametrizedClasses() {
        return this.parametrizedClasses;
    }

    public String toString() {
        return "SubscriptionInfo [type=" + this.type + ", converter=" + this.converter + "]";
    }

    public static <S, T> SubscriptionInfoBuilder<S, T> builder() {
        return new SubscriptionInfoBuilder();
    }

    public static class SubscriptionInfoBuilder<S, T> {
        private EventUnmarshaller<S> converter;
        private Class<T> outputClass;
        private Class<?>[] parametrizedClasses = null;
        private String type = null;

        public SubscriptionInfoBuilder converter(EventUnmarshaller<S> converter) {
            this.converter = converter;
            return this;
        }

        public SubscriptionInfoBuilder outputClass(Class<T> outputClass) {
            this.outputClass = outputClass;
            return this;
        }

        public SubscriptionInfoBuilder parametrizedClasses(Class<?> ... parametrizedClasses) {
            this.parametrizedClasses = parametrizedClasses;
            return this;
        }

        public SubscriptionInfoBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SubscriptionInfo createSubscriptionInfo() {
            return new SubscriptionInfo<S, T>(this.converter, this.outputClass, this.parametrizedClasses, this.type);
        }
    }
}

