/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.process;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ProcessInstanceNodeEventBody {
    public static final int EVENT_TYPE_ENTER = 1;
    public static final int EVENT_TYPE_EXIT = 2;
    public static final int EVENT_TYPE_ABORTED = 3;
    public static final int EVENT_TYPE_SKIPPED = 4;
    public static final int EVENT_TYPE_OBSOLETE = 5;
    public static final int EVENT_TYPE_ERROR = 6;
    private Date eventDate;
    private String eventUser;
    private Integer eventType;
    private String processId;
    private String processVersion;
    private String processInstanceId;
    private String connectionNodeDefinitionId;
    private String nodeDefinitionId;
    private String nodeName;
    private String nodeType;
    private String nodeInstanceId;
    private String workItemId;
    private Date slaDueDate;
    private Map<String, Object> data = new HashMap<String, Object>();

    private ProcessInstanceNodeEventBody() {
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public String getEventUser() {
        return this.eventUser;
    }

    public Integer getEventType() {
        return this.eventType;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getConnectionNodeDefinitionId() {
        return this.connectionNodeDefinitionId;
    }

    public String getNodeDefinitionId() {
        return this.nodeDefinitionId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    public Date getSlaDueDate() {
        return this.slaDueDate;
    }

    public String getWorkItemId() {
        return this.workItemId;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String toString() {
        return "ProcessInstanceNodeEventBody [eventDate=" + this.eventDate + ", eventUser=" + this.eventUser + ", eventType=" + this.eventType + ", processId=" + this.processId + ", processVersion=" + this.processVersion + ", processInstanceId=" + this.processInstanceId + ", connectionNodeInstanceId=" + this.connectionNodeDefinitionId + ", nodeDefinitionId=" + this.nodeDefinitionId + ", nodeName=" + this.nodeName + ", nodeType=" + this.nodeType + ", nodeInstanceId=" + this.nodeInstanceId + ", data=" + this.data + "]";
    }

    public int hashCode() {
        return Objects.hash(this.nodeInstanceId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceNodeEventBody other = (ProcessInstanceNodeEventBody)obj;
        return Objects.equals(this.nodeInstanceId, other.nodeInstanceId);
    }

    public Builder update() {
        return new Builder(this);
    }

    public static Builder create() {
        return new Builder(new ProcessInstanceNodeEventBody());
    }

    public static class Builder {
        private ProcessInstanceNodeEventBody instance;

        private Builder(ProcessInstanceNodeEventBody instance) {
            this.instance = instance;
        }

        public Builder eventDate(Date eventDate) {
            this.instance.eventDate = eventDate;
            return this;
        }

        public Builder eventUser(String userId) {
            this.instance.eventUser = userId;
            return this;
        }

        public Builder eventType(Integer eventType) {
            this.instance.eventType = eventType;
            return this;
        }

        public Builder processId(String processId) {
            this.instance.processId = processId;
            return this;
        }

        public Builder processVersion(String processVersion) {
            this.instance.processVersion = processVersion;
            return this;
        }

        public Builder processInstanceId(String processInstanceId) {
            this.instance.processInstanceId = processInstanceId;
            return this;
        }

        public Builder connectionNodeDefinitionId(String connectionNodeDefinitionId) {
            this.instance.connectionNodeDefinitionId = connectionNodeDefinitionId;
            return this;
        }

        public Builder nodeDefinitionId(String nodeDefinitionId) {
            this.instance.nodeDefinitionId = nodeDefinitionId;
            return this;
        }

        public Builder nodeName(String nodeName) {
            this.instance.nodeName = nodeName;
            return this;
        }

        public Builder nodeType(String nodeType) {
            this.instance.nodeType = nodeType;
            return this;
        }

        public Builder nodeInstanceId(String nodeInstanceId) {
            this.instance.nodeInstanceId = nodeInstanceId;
            return this;
        }

        public Builder data(String name, Object value) {
            this.instance.data.put(name, value);
            return this;
        }

        public Builder slaDueDate(Date slaDueDate) {
            this.instance.slaDueDate = slaDueDate;
            return this;
        }

        public Builder workItemId(String workItemId) {
            this.instance.workItemId = workItemId;
            return this;
        }

        public ProcessInstanceNodeEventBody build() {
            return this.instance;
        }
    }
}

