/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.process;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ProcessInstanceVariableEventBody {
    private Date eventDate;
    private String eventUser;
    private String processId;
    private String processVersion;
    private String processInstanceId;
    private String nodeContainerDefinitionId;
    private String nodeContainerInstanceId;
    private String variableId;
    private String variableName;
    private Object variableValue;

    public Date getEventDate() {
        return this.eventDate;
    }

    public String getEventUser() {
        return this.eventUser;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getNodeContainerDefinitionId() {
        return this.nodeContainerDefinitionId;
    }

    public String getNodeContainerInstanceId() {
        return this.nodeContainerInstanceId;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public Object getVariableValue() {
        return this.variableValue;
    }

    public Map<String, String> metaData() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("kogito.processinstance.id", this.processInstanceId);
        metadata.put("kogito.process.id", this.processId);
        return metadata;
    }

    public String toString() {
        return "ProcessInstanceVariableEventBody [eventDate=" + this.eventDate + ", eventUser=" + this.eventUser + ", processId=" + this.processId + ", processVersion=" + this.processVersion + ", processInstanceId=" + this.processInstanceId + ", nodeContainerDefinitionId=" + this.nodeContainerDefinitionId + ", nodeContainerInstanceId=" + this.nodeContainerInstanceId + ", variableId=" + this.variableId + ", variableName=" + this.variableName + ", variableValue=" + this.variableValue + "]";
    }

    public int hashCode() {
        return Objects.hash(this.nodeContainerInstanceId, this.processInstanceId, this.variableId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceVariableEventBody other = (ProcessInstanceVariableEventBody)obj;
        return Objects.equals(this.nodeContainerInstanceId, other.nodeContainerInstanceId) && Objects.equals(this.processInstanceId, other.processInstanceId) && Objects.equals(this.variableId, other.variableId);
    }

    public static Builder create() {
        return new Builder(new ProcessInstanceVariableEventBody());
    }

    public static class Builder {
        private ProcessInstanceVariableEventBody instance;

        public Builder(ProcessInstanceVariableEventBody instance) {
            this.instance = instance;
        }

        public Builder eventDate(Date eventDate) {
            this.instance.eventDate = eventDate;
            return this;
        }

        public Builder eventUser(String userId) {
            this.instance.eventUser = userId;
            return this;
        }

        public Builder processId(String processId) {
            this.instance.processId = processId;
            return this;
        }

        public Builder processVersion(String processVersion) {
            this.instance.processVersion = processVersion;
            return this;
        }

        public Builder processInstanceId(String processInstanceId) {
            this.instance.processInstanceId = processInstanceId;
            return this;
        }

        public Builder nodeContainerDefinitionId(String nodeContainerDefinitionId) {
            this.instance.nodeContainerDefinitionId = nodeContainerDefinitionId;
            return this;
        }

        public Builder nodeContainerInstanceId(String nodeContainerInstanceId) {
            this.instance.nodeContainerInstanceId = nodeContainerInstanceId;
            return this;
        }

        public Builder variableId(String variableId) {
            this.instance.variableId = variableId;
            return this;
        }

        public Builder variableName(String variableName) {
            this.instance.variableName = variableName;
            return this;
        }

        public Builder variableValue(Object variableValue) {
            this.instance.variableValue = variableValue;
            return this;
        }

        public ProcessInstanceVariableEventBody build() {
            return this.instance;
        }
    }
}

