/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.usertask;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class UserTaskInstanceStateEventBody {
    private Date eventDate;
    private String eventUser;
    private String userTaskDefinitionId;
    private String userTaskInstanceId;
    private String userTaskName;
    private String userTaskDescription;
    private String userTaskPriority;
    private String userTaskReferenceName;
    private String state;
    private String actualOwner;
    private String processInstanceId;
    private String eventType;

    public Date getEventDate() {
        return this.eventDate;
    }

    public String getEventUser() {
        return this.eventUser;
    }

    public String getUserTaskDefinitionId() {
        return this.userTaskDefinitionId;
    }

    public String getUserTaskInstanceId() {
        return this.userTaskInstanceId;
    }

    public String getUserTaskName() {
        return this.userTaskName;
    }

    public String getUserTaskDescription() {
        return this.userTaskDescription;
    }

    public String getUserTaskPriority() {
        return this.userTaskPriority;
    }

    public String getUserTaskReferenceName() {
        return this.userTaskReferenceName;
    }

    public String getState() {
        return this.state;
    }

    public String getActualOwner() {
        return this.actualOwner;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public Map<String, Object> metaData() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("kogito.usertaskinstance.id", this.userTaskInstanceId);
        metadata.put("kogito.processinstance.id", this.processInstanceId);
        metadata.put("kogito.usertaskinstance.state", this.state);
        return metadata;
    }

    public String toString() {
        return "UserTaskInstanceStateEventBody [eventDate=" + this.eventDate + ", eventUser=" + this.eventUser + ", userTaskDefinitionId=" + this.userTaskDefinitionId + ", userTaskInstanceId=" + this.userTaskInstanceId + ", userTaskName=" + this.userTaskName + ", userTaskDescription=" + this.userTaskDescription + ", userTaskPriority=" + this.userTaskPriority + ", userTaskReferenceName=" + this.userTaskReferenceName + ", state=" + this.state + ", actualOwner=" + this.actualOwner + ", processInstanceId=" + this.processInstanceId + "]";
    }

    public Builder update() {
        return new Builder(this);
    }

    public static Builder create() {
        return new Builder(new UserTaskInstanceStateEventBody());
    }

    public int hashCode() {
        return Objects.hash(this.userTaskInstanceId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserTaskInstanceStateEventBody other = (UserTaskInstanceStateEventBody)obj;
        return Objects.equals(this.userTaskInstanceId, other.userTaskInstanceId);
    }

    public static class Builder {
        private UserTaskInstanceStateEventBody instance;

        private Builder(UserTaskInstanceStateEventBody instance) {
            this.instance = instance;
        }

        public Builder eventDate(Date eventDate) {
            this.instance.eventDate = eventDate;
            return this;
        }

        public Builder eventUser(String userId) {
            this.instance.eventUser = userId;
            return this;
        }

        public Builder userTaskDefinitionId(String userTaskDefinitionId) {
            this.instance.userTaskDefinitionId = userTaskDefinitionId;
            return this;
        }

        public Builder userTaskInstanceId(String userTaskInstanceId) {
            this.instance.userTaskInstanceId = userTaskInstanceId;
            return this;
        }

        public Builder userTaskName(String userTaskName) {
            this.instance.userTaskName = userTaskName;
            return this;
        }

        public Builder userTaskDescription(String userTaskDescription) {
            this.instance.userTaskDescription = userTaskDescription;
            return this;
        }

        public Builder userTaskPriority(String userTaskPriority) {
            this.instance.userTaskPriority = userTaskPriority;
            return this;
        }

        public Builder userTaskReferenceName(String userTaskReferenceName) {
            this.instance.userTaskReferenceName = userTaskReferenceName;
            return this;
        }

        public Builder state(String state) {
            this.instance.state = state;
            return this;
        }

        public Builder actualOwner(String userId) {
            this.instance.actualOwner = userId;
            return this;
        }

        public Builder eventType(String eventType) {
            this.instance.eventType = eventType;
            return this;
        }

        public Builder processInstanceId(String processInstanceId) {
            this.instance.processInstanceId = processInstanceId;
            return this;
        }

        public UserTaskInstanceStateEventBody build() {
            return this.instance;
        }
    }
}

