/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.rm;

import io.smallrye.reactive.messaging.annotations.Emitter;
import io.smallrye.reactive.messaging.annotations.Stream;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReactiveMessagingEventPublisher
implements EventPublisher {
    private static final String TOPIC_NAME = "kogito-processinstances-events";
    private static final Logger logger = LoggerFactory.getLogger(ReactiveMessagingEventPublisher.class);
    private Jsonb jsonb = JsonbBuilder.create();
    @Inject
    @Stream(value="kogito-processinstances-events")
    Emitter<String> eventsEmitter;

    public void publish(DataEvent<?> event) {
        logger.debug("About to publish event {} to topic {}", event, (Object)TOPIC_NAME);
        try {
            String eventString = this.jsonb.toJson(event);
            logger.debug("Event payload '{}'", (Object)eventString);
            this.eventsEmitter.send((Object)eventString);
            logger.debug("Successfully published event {} to topic {}", event, (Object)TOPIC_NAME);
        }
        catch (Exception e) {
            logger.error("Error while publishing event to topic {} for event {}", new Object[]{TOPIC_NAME, event, e});
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        for (DataEvent<?> event : events) {
            this.publish(event);
        }
    }
}

