/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.rm;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReactiveMessagingEventPublisher
implements EventPublisher {
    private static final String PI_TOPIC_NAME = "kogito-processinstances-events";
    private static final String UI_TOPIC_NAME = "kogito-usertaskinstances-events";
    private static final String VI_TOPIC_NAME = "kogito-variables-events";
    private static final Logger logger = LoggerFactory.getLogger(ReactiveMessagingEventPublisher.class);
    private ObjectMapper json = new ObjectMapper();
    @Inject
    @Channel(value="kogito-processinstances-events")
    Emitter<String> processInstancesEventsEmitter;
    @Inject
    @Channel(value="kogito-usertaskinstances-events")
    Emitter<String> userTasksEventsEmitter;
    @Inject
    @Channel(value="kogito-variables-events")
    Emitter<String> variablesEventsEmitter;
    @Inject
    @ConfigProperty(name="kogito.events.processinstances.enabled")
    Optional<Boolean> processInstancesEvents;
    @Inject
    @ConfigProperty(name="kogito.events.usertasks.enabled")
    Optional<Boolean> userTasksEvents;
    @Inject
    @ConfigProperty(name="kogito.events.variables.enabled")
    Optional<Boolean> variablesEvents;

    @PostConstruct
    public void configure() {
        this.json.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true).withTimeZone(TimeZone.getDefault()));
    }

    public void publish(DataEvent<?> event) {
        if (event.getType().equals("ProcessInstanceEvent") && this.processInstancesEvents.orElse(true).booleanValue()) {
            this.publishToTopic(event, this.processInstancesEventsEmitter, PI_TOPIC_NAME);
        } else if (event.getType().equals("UserTaskInstanceEvent") && this.userTasksEvents.orElse(true).booleanValue()) {
            this.publishToTopic(event, this.userTasksEventsEmitter, UI_TOPIC_NAME);
        } else if (event.getType().equals("VariableInstanceEvent") && this.variablesEvents.orElse(true).booleanValue()) {
            this.publishToTopic(event, this.variablesEventsEmitter, VI_TOPIC_NAME);
        } else {
            logger.warn("Unknown type of event '{}', ignoring", (Object)event.getType());
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        for (DataEvent<?> event : events) {
            this.publish(event);
        }
    }

    protected void publishToTopic(DataEvent<?> event, Emitter<String> emitter, String topic) {
        if (emitter.hasRequests()) {
            logger.debug("Emitter {} is not ready to send messages", (Object)topic);
        }
        logger.debug("About to publish event {} to topic {}", event, (Object)topic);
        try {
            String eventString = this.json.writeValueAsString(event);
            logger.debug("Event payload '{}'", (Object)eventString);
            emitter.send((Object)eventString);
            logger.debug("Successfully published event {} to topic {}", event, (Object)topic);
        }
        catch (Exception e) {
            logger.error("Error while publishing event to topic {} for event {}", new Object[]{topic, event, e});
        }
    }
}

