/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class KafkaEventPublisher
implements EventPublisher {
    private static final String TOPIC_NAME = "kogito-processinstances-events";
    private static final Logger logger = LoggerFactory.getLogger(KafkaEventPublisher.class);
    private ObjectMapper json = new ObjectMapper();
    @Autowired
    private KafkaTemplate<String, String> eventsEmitter;

    public void publish(DataEvent<?> event) {
        logger.debug("About to publish event {} to Kafka topic {}", event, (Object)TOPIC_NAME);
        try {
            String eventString = this.json.writeValueAsString(event);
            logger.debug("Event payload '{}'", (Object)eventString);
            this.eventsEmitter.send(TOPIC_NAME, (Object)eventString);
            logger.debug("Successfully published event {} to topic {}", event, (Object)TOPIC_NAME);
        }
        catch (Exception e) {
            logger.error("Error while publishing event to Kafka topic {} for event {}", new Object[]{TOPIC_NAME, event, e});
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        for (DataEvent<?> event : events) {
            this.publish(event);
        }
    }
}

