/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.net.URI;

class CommonObjectModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public CommonObjectModule() {
        this.addDeserializer(URI.class, (JsonDeserializer)new JsonDeserializer<URI>(){

            public URI deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                return URI.create(CommonObjectModule.fromNode(p));
            }
        });
        this.addDeserializer(File.class, (JsonDeserializer)new JsonDeserializer<File>(){

            public File deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                return new File(CommonObjectModule.fromNode(p));
            }
        });
    }

    private static String fromNode(JsonParser p) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (node.size() == 1) {
            node = (JsonNode)node.iterator().next();
        }
        if (node.isTextual()) {
            return node.asText();
        }
        throw new IOException(node + "should be a string or have exactly one property of type string");
    }
}

