/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.Optional;
import java.util.function.Function;
import org.kie.kogito.jackson.utils.FunctionBaseJsonNode;

public class PrefixJsonNode<T>
extends FunctionBaseJsonNode {
    private static final long serialVersionUID = 1L;
    private final transient String prefix;
    private final transient Function<String, Optional<T>> function;
    private transient Optional<T> value;

    public PrefixJsonNode(Function<String, Optional<T>> function) {
        this(null, function);
    }

    public PrefixJsonNode(String prefix, Function<String, Optional<T>> function) {
        this.prefix = prefix;
        this.function = function;
        this.value = prefix == null ? Optional.empty() : function.apply(prefix);
    }

    @Override
    public JsonNodeType getNodeType() {
        return this.value.isPresent() ? JsonNodeType.STRING : JsonNodeType.OBJECT;
    }

    @Override
    public String asText() {
        return this.value.map(Object::toString).orElse(null);
    }

    public JsonNode get(String fieldName) {
        return new PrefixJsonNode<T>((String)(this.prefix == null ? fieldName : this.prefix + "." + fieldName), this.function);
    }
}

