/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Output;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.process.workitems.impl.expr.Expression;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;

public class JqExpression
implements Expression {
    private final Supplier<Scope> scope;
    private final String expr;
    private JsonQuery query;
    private Boolean isValid;

    public JqExpression(Supplier<Scope> scope, String expr) {
        this.expr = expr;
        this.scope = scope;
    }

    private <T> TypedOutput<T> output(Class<T> returnClass) {
        TypedOutput<Boolean> out = Boolean.class.isAssignableFrom(returnClass) ? new BooleanOutput() : (String.class.isAssignableFrom(returnClass) ? new StringOutput() : (Collection.class.isAssignableFrom(returnClass) ? new CollectionOutput() : new JsonNodeOutput()));
        return out;
    }

    public <T> T eval(Object context, Class<T> returnClass) {
        try {
            TypedOutput<T> output = this.output(returnClass);
            this.compile();
            this.query.apply(this.scope.get(), (JsonNode)context, output);
            return output.getResult();
        }
        catch (JsonQueryException e) {
            throw new IllegalArgumentException("Unable to evaluate content " + context + " using query " + this.query, e);
        }
    }

    public void assign(Object context, Object value) {
        ExpressionHandlerUtils.assign((JsonNode)((JsonNode)context), (JsonNode)this.eval(context, JsonNode.class), (JsonNode)((JsonNode)value), (String)this.expr);
    }

    private void compile() throws JsonQueryException {
        if (this.query == null) {
            this.query = JsonQuery.compile((String)this.expr, (Version)Versions.JQ_1_6);
        }
    }

    public boolean isValid() {
        if (this.isValid == null) {
            try {
                this.compile();
                this.isValid = true;
            }
            catch (JsonQueryException e) {
                this.isValid = false;
            }
        }
        return this.isValid;
    }

    private static class JsonNodeOutput
    implements TypedOutput<JsonNode> {
        private JsonNode result;
        private boolean arrayCreated;

        private JsonNodeOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            if (this.result == null) {
                this.result = out;
            } else if (!this.arrayCreated) {
                ArrayNode newNode = ObjectMapperFactory.get().createArrayNode();
                newNode.add(this.result).add(out);
                this.result = newNode;
                this.arrayCreated = true;
            } else {
                ((ArrayNode)this.result).add(out);
            }
        }

        @Override
        public JsonNode getResult() {
            return this.result;
        }
    }

    private static class CollectionOutput
    implements TypedOutput<Collection> {
        Collection result = new ArrayList();

        private CollectionOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            Object obj = JsonObjectUtils.toJavaValue((JsonNode)out);
            if (obj instanceof Collection) {
                this.result.addAll((Collection)obj);
            } else {
                this.result.add(obj);
            }
        }

        @Override
        public Collection<?> getResult() {
            return this.result;
        }
    }

    private static class StringOutput
    implements TypedOutput<String> {
        StringBuilder sb = new StringBuilder();

        private StringOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            if (this.sb.length() > 0) {
                this.sb.append(' ');
            }
            this.sb.append(out.asText());
        }

        @Override
        public String getResult() {
            return this.sb.toString();
        }
    }

    private static class BooleanOutput
    implements TypedOutput<Boolean> {
        boolean result;

        private BooleanOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            this.result = out.asBoolean();
        }

        @Override
        public Boolean getResult() {
            return this.result;
        }
    }

    private static interface TypedOutput<T>
    extends Output {
        public T getResult();
    }
}

