/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.regex.Pattern;
import org.kie.kogito.process.workitems.impl.expr.Expression;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;

public class JsonPathExpression
implements Expression {
    private static final Configuration jsonPathConfig = Configuration.builder().mappingProvider((MappingProvider)new JacksonMappingProvider()).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build();
    private static final Pattern jsonPathRegexPattern = Pattern.compile("^((\\$\\[).*|(\\$\\.).*)");
    private final String expr;
    private final ParseContext jsonPath = JsonPath.using((Configuration)jsonPathConfig);
    private Boolean isValid;

    public JsonPathExpression(String expr) {
        this.expr = expr;
    }

    public <T> T eval(Object context, Class<T> returnClass) {
        DocumentContext parsedContext = this.jsonPath.parse(context);
        if (String.class.isAssignableFrom(returnClass)) {
            StringBuilder sb = new StringBuilder();
            for (String part : this.expr.split("((?=\\$))")) {
                JsonNode partResult = (JsonNode)parsedContext.read(part, JsonNode.class, new Predicate[0]);
                sb.append(partResult.isTextual() ? partResult.asText() : partResult.toPrettyString());
            }
            return (T)sb.toString();
        }
        Object result = parsedContext.read(this.expr, new Predicate[0]);
        return (T)(Boolean.class.isAssignableFrom(returnClass) && result instanceof ArrayNode ? Boolean.valueOf(!((ArrayNode)result).isEmpty()) : jsonPathConfig.mappingProvider().map(result, returnClass, jsonPathConfig));
    }

    public void assign(Object context, Object value) {
        NullNode target;
        try {
            target = this.eval(context, JsonNode.class);
        }
        catch (PathNotFoundException ex) {
            target = NullNode.instance;
        }
        ExpressionHandlerUtils.assign((JsonNode)((JsonNode)context), (JsonNode)target, (JsonNode)((JsonNode)value), (String)this.expr);
    }

    public boolean isValid() {
        if (this.isValid == null) {
            this.isValid = jsonPathRegexPattern.matcher(this.expr).matches();
        }
        return this.isValid;
    }
}

