/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Optional;
import java.util.regex.Pattern;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;

public class JsonPathExpression
implements Expression {
    private static final Configuration jsonPathConfig = Configuration.builder().mappingProvider((MappingProvider)new JacksonMappingProvider()).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build();
    private static final Pattern jsonPathRegexPattern = Pattern.compile("^((\\$\\[).*|(\\$\\.).*)");
    private final String expr;
    private final ParseContext jsonPath = JsonPath.using((Configuration)jsonPathConfig);
    private Boolean isValid;

    public JsonPathExpression(String expr) {
        this.expr = expr;
    }

    private <T> T eval(JsonNode context, Class<T> returnClass, KogitoProcessContext processInfo) {
        DocumentContext parsedContext = this.jsonPath.parse((Object)context);
        if (String.class.isAssignableFrom(returnClass)) {
            StringBuilder sb = new StringBuilder();
            for (String part : ExpressionHandlerUtils.prepareExpr((String)this.expr, Optional.ofNullable(processInfo)).split("((?=\\$))")) {
                JsonNode partResult = (JsonNode)parsedContext.read(part, JsonNode.class, new Predicate[0]);
                sb.append(partResult.isTextual() ? partResult.asText() : partResult.toPrettyString());
            }
            return (T)sb.toString();
        }
        Object result = parsedContext.read(this.expr, new Predicate[0]);
        return (T)(Boolean.class.isAssignableFrom(returnClass) && result instanceof ArrayNode ? Boolean.valueOf(!((ArrayNode)result).isEmpty()) : jsonPathConfig.mappingProvider().map(result, returnClass, jsonPathConfig));
    }

    private void assign(JsonNode context, Object value, KogitoProcessContext processInfo) {
        NullNode target;
        try {
            target = this.eval(context, JsonNode.class, processInfo);
        }
        catch (PathNotFoundException ex) {
            target = NullNode.instance;
        }
        ExpressionHandlerUtils.assign((JsonNode)context, (JsonNode)target, (JsonNode)((JsonNode)value), (String)this.expr);
    }

    public boolean isValid() {
        if (this.isValid == null) {
            this.isValid = jsonPathRegexPattern.matcher(this.expr).matches();
        }
        return this.isValid;
    }

    public <T> T eval(Object target, Class<T> returnClass, KogitoProcessContext context) {
        return this.eval(JsonObjectUtils.fromValue((Object)target), returnClass, context);
    }

    public void assign(Object target, Object value, KogitoProcessContext context) {
        this.assign(JsonObjectUtils.fromValue((Object)target), (Object)JsonObjectUtils.fromValue((Object)value), context);
    }
}

