/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Map;
import org.kie.kogito.expr.jsonpath.JsonPathJacksonProvider;
import org.kie.kogito.expr.jsonpath.WorkflowJacksonJsonNodeJsonProvider;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;

public class JsonPathExpression
implements Expression {
    static final String LANG = "jsonpath";
    private final String expr;
    private Boolean isValid;
    private Exception validationError;

    public JsonPathExpression(String expr) {
        expr = JsonPathExpression.replaceMagic(expr, "CONST");
        expr = JsonPathExpression.replaceMagic(expr, "SECRET");
        this.expr = expr = JsonPathExpression.replaceMagic(expr, "WORKFLOW");
    }

    private static final String replaceMagic(String expr, String magic) {
        magic = "$" + (String)magic;
        return expr.replace((CharSequence)magic, "$." + (String)magic);
    }

    private Configuration getConfiguration(KogitoProcessContext context) {
        return Configuration.builder().mappingProvider((MappingProvider)new JsonPathJacksonProvider()).jsonProvider((JsonProvider)new WorkflowJacksonJsonNodeJsonProvider(context)).build();
    }

    private static boolean isContextAware(JsonNode context, Map<String, JsonNode> additionalVars) {
        return !additionalVars.isEmpty() && context instanceof ObjectNode;
    }

    private <T> T eval(JsonNode context, Class<T> returnClass, KogitoProcessContext processInfo) {
        Configuration jsonPathConfig = this.getConfiguration(processInfo);
        DocumentContext parsedContext = JsonPath.using((Configuration)jsonPathConfig).parse((Object)context);
        if (String.class.isAssignableFrom(returnClass)) {
            StringBuilder sb = new StringBuilder();
            for (String part : this.expr.split("((?=\\$\\.|\\$\\[))")) {
                JsonNode partResult = (JsonNode)parsedContext.read(part, JsonNode.class, new Predicate[0]);
                sb.append(partResult.isTextual() ? partResult.asText() : partResult.toPrettyString());
            }
            return (T)sb.toString();
        }
        Object result = parsedContext.read(this.expr, new Predicate[0]);
        return (T)(Boolean.class.isAssignableFrom(returnClass) && result instanceof ArrayNode ? Boolean.valueOf(!((ArrayNode)result).isEmpty()) : JsonObjectUtils.convertValue((Object)jsonPathConfig.mappingProvider().map(result, returnClass, jsonPathConfig), returnClass));
    }

    private void assign(JsonNode context, Object value, KogitoProcessContext processInfo) {
        NullNode target;
        try {
            target = this.eval(context, JsonNode.class, processInfo);
        }
        catch (PathNotFoundException ex) {
            target = NullNode.instance;
        }
        ExpressionHandlerUtils.assign((JsonNode)context, (JsonNode)target, (JsonNode)((JsonNode)value), (String)this.expr);
    }

    public boolean isValid() {
        if (this.isValid == null) {
            try {
                JsonPath.compile((String)this.expr, (Predicate[])new Predicate[0]);
                this.isValid = true;
            }
            catch (JsonPathException ex) {
                this.validationError = ex;
                this.isValid = false;
            }
        }
        return this.isValid;
    }

    public <T> T eval(Object target, Class<T> returnClass, KogitoProcessContext context) {
        return this.eval(JsonObjectUtils.fromValue((Object)target), returnClass, context);
    }

    public void assign(Object target, Object value, KogitoProcessContext context) {
        this.assign(JsonObjectUtils.fromValue((Object)target), (Object)JsonObjectUtils.fromValue((Object)value), context);
    }

    public String asString() {
        return this.expr;
    }

    public Exception validationError() {
        return this.validationError;
    }

    public String lang() {
        return LANG;
    }
}

