/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import java.util.Map;
import java.util.function.Function;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.FunctionBaseJsonNode;
import org.kie.kogito.jackson.utils.PrefixJsonNode;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;
import org.kie.kogito.serverless.workflow.utils.VariablesHelper;

public class WorkflowJacksonJsonNodeJsonProvider
extends JacksonJsonNodeJsonProvider {
    private KogitoProcessContext context;
    private Map<String, JsonNode> variables;

    public WorkflowJacksonJsonNodeJsonProvider(KogitoProcessContext context) {
        this.context = context;
        this.variables = VariablesHelper.getAdditionalVariables((KogitoProcessContext)context);
    }

    public Object getMapValue(Object obj, String key) {
        if (obj instanceof Function) {
            return ((Function)obj).apply(key);
        }
        if (obj instanceof FunctionBaseJsonNode) {
            return ((FunctionBaseJsonNode)obj).get(key);
        }
        switch (key) {
            case "$SECRET": {
                return new PrefixJsonNode(ExpressionHandlerUtils::getOptionalSecret);
            }
            case "$WORKFLOW": {
                return ExpressionHandlerUtils.getContextFunction((KogitoProcessContext)this.context);
            }
            case "$CONST": {
                return ExpressionHandlerUtils.getConstants((KogitoProcessContext)this.context);
            }
        }
        return this.variables.containsKey(key) ? this.variables.get(key) : super.getMapValue(obj, key);
    }

    public boolean isMap(Object obj) {
        return super.isMap(obj) || obj instanceof Function || obj instanceof FunctionBaseJsonNode;
    }
}

