/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.rules.RuleCodegen;
import org.kie.kogito.maven.plugin.AbstractKieMojo;
import org.kie.kogito.maven.plugin.util.MojoUtil;

@Mojo(name="generateModel", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class GenerateModelMojo
extends AbstractKieMojo {
    private static final String MAIN_JAVA_DIRECTORY = "main/java";
    private static final String JAVA_FILE_SUFFIX = ".java";
    public static final PathMatcher drlFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.drl");
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/kogito")
    private File generatedSources;
    @Parameter(property="kogito.codegen.rules", defaultValue="")
    private String generateRules;
    @Parameter(property="kogito.codegen.processes", defaultValue="")
    private String generateProcesses;
    @Parameter(property="kogito.sources.keep", defaultValue="false")
    private boolean keepSources;
    @Parameter(property="kogito.di.enabled", defaultValue="true")
    private boolean dependencyInjection;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.generateModel();
        }
        catch (IOException e) {
            throw new MojoExecutionException("An I/O error occurred", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModel() throws MojoExecutionException, IOException {
        boolean genRules = this.generateRules == null ? this.rulesExist() : Boolean.parseBoolean(this.generateRules);
        boolean genProcesses = this.generateProcesses == null ? this.processesExist() : Boolean.parseBoolean(this.generateProcesses);
        this.project.addCompileSourceRoot(this.generatedSources.getPath());
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.setSystemProperties(this.properties);
            ClassLoader projectClassLoader = MojoUtil.createProjectClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.project, this.outputDirectory, null);
            Thread.currentThread().setContextClassLoader(projectClassLoader);
            ApplicationGenerator appGen = this.createApplicationGenerator(genRules, genProcesses);
            for (GeneratedFile generatedFile : appGen.generate()) {
                this.writeGeneratedFile(generatedFile);
            }
            if (!this.keepSources) {
                this.deleteDrlFiles();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private boolean processesExist() throws IOException {
        try (Stream<Path> paths = Files.walk(this.projectDir.toPath(), new FileVisitOption[0]);){
            boolean bl = paths.map(p -> p.toString().toLowerCase()).anyMatch(p -> p.endsWith(".bpmn") || p.endsWith(".bpmn2"));
            return bl;
        }
    }

    private boolean rulesExist() throws IOException {
        try (Stream<Path> paths = Files.walk(this.projectDir.toPath(), new FileVisitOption[0]);){
            boolean bl = paths.anyMatch(p -> p.toString().toLowerCase().endsWith(".drl"));
            return bl;
        }
    }

    private ApplicationGenerator createApplicationGenerator(boolean generateRuleUnits, boolean generateProcesses) throws IOException {
        String appPackageName = this.project.getGroupId();
        Path projectPath = this.projectDir.toPath();
        if (appPackageName.equals("org.kie.kogito")) {
            appPackageName = "org.kie.kogito.app";
        }
        ApplicationGenerator appGen = new ApplicationGenerator(appPackageName, this.targetDirectory).withDependencyInjection(this.dependencyInjection);
        if (generateRuleUnits) {
            ((RuleCodegen)appGen.withGenerator((Generator)RuleCodegen.ofPath((Path)projectPath, (boolean)false))).withRuleEventListenersConfig(this.customRuleEventListenerConfigExists(appPackageName));
        }
        if (generateProcesses) {
            ((ProcessCodegen)appGen.withGenerator((Generator)ProcessCodegen.ofPath((Path)projectPath))).withWorkItemHandlerConfig(this.customWorkItemConfigExists(appPackageName)).withProcessEventListenerConfig(this.customProcessListenerConfigExists(appPackageName));
        }
        return appGen;
    }

    private String customWorkItemConfigExists(String appPackageName) {
        String sourceDir = Paths.get(this.projectDir.getPath(), "src").toString();
        String workItemHandlerConfigClass = ProcessCodegen.defaultWorkItemHandlerConfigClass((String)appPackageName);
        Path p = Paths.get(sourceDir, MAIN_JAVA_DIRECTORY, workItemHandlerConfigClass.replace('.', '/') + JAVA_FILE_SUFFIX);
        return p.toFile().exists() ? workItemHandlerConfigClass : null;
    }

    private String customProcessListenerConfigExists(String appPackageName) {
        String sourceDir = Paths.get(this.projectDir.getPath(), "src").toString();
        String processEventListenerClass = ProcessCodegen.defaultProcessListenerConfigClass((String)appPackageName);
        Path p = Paths.get(sourceDir, MAIN_JAVA_DIRECTORY, processEventListenerClass.replace('.', '/') + JAVA_FILE_SUFFIX);
        return p.toFile().exists() ? processEventListenerClass : null;
    }

    private String customRuleEventListenerConfigExists(String appPackageName) {
        String sourceDir = Paths.get(this.projectDir.getPath(), "src").toString();
        String ruleEventListenerConfiglass = RuleCodegen.defaultRuleEventListenerConfigClass((String)appPackageName);
        Path p = Paths.get(sourceDir, MAIN_JAVA_DIRECTORY, ruleEventListenerConfiglass.replace('.', '/') + JAVA_FILE_SUFFIX);
        return p.toFile().exists() ? ruleEventListenerConfiglass : null;
    }

    private void writeGeneratedFile(GeneratedFile f) throws IOException {
        Files.write(this.pathOf(f.relativePath()), f.contents(), new OpenOption[0]);
    }

    private Path pathOf(String end) {
        Path path = Paths.get(this.generatedSources.getPath(), end);
        path.getParent().toFile().mkdirs();
        return path;
    }

    private void deleteDrlFiles() throws MojoExecutionException {
        try (Stream<Path> drlFiles = Files.find(this.outputDirectory.toPath(), Integer.MAX_VALUE, (p, f) -> drlFileMatcher.matches((Path)p), new FileVisitOption[0]);){
            drlFiles.forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to find .drl files");
        }
    }
}

