/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.MojoExecutionException;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;

public class ResourceFileWriter {
    private MemoryFileSystem mfs;
    private String targetDirectory;

    public ResourceFileWriter(MemoryFileSystem mfs, String targetDirectory) {
        this.mfs = mfs;
        this.targetDirectory = targetDirectory;
    }

    public void write() throws MojoExecutionException {
        MemoryFile packagesMemoryFile = (MemoryFile)this.mfs.getFile("META-INF/kie/drools-model");
        String packagesMemoryFilePath = packagesMemoryFile.getFolder().getPath().toPortableString();
        Path packagesDestinationPath = Paths.get(this.targetDirectory, "classes", packagesMemoryFilePath, packagesMemoryFile.getName());
        try {
            if (!packagesDestinationPath.toFile().exists()) {
                Files.createDirectories(packagesDestinationPath.getParent(), new FileAttribute[0]);
            }
            Files.copy(packagesMemoryFile.getContents(), packagesDestinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write file", (Exception)e);
        }
    }
}

