/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.rules.DeclaredTypeCodegen;
import org.kie.kogito.maven.plugin.AbstractKieMojo;
import org.kie.kogito.maven.plugin.util.MojoUtil;

@Mojo(name="generateDeclaredTypes", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class GenerateDeclaredTypes
extends AbstractKieMojo {
    public static final List<String> DROOLS_EXTENSIONS = Arrays.asList(".drl", ".xls", ".xlsx", ".csv");
    public static final PathMatcher drlFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.drl");
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/kogito")
    private File generatedSources;
    @Parameter(property="kogito.codegen.rules", defaultValue="")
    private String generateRules;
    @Parameter(property="kogito.codegen.processes", defaultValue="")
    private String generateProcesses;
    @Parameter(property="kogito.codegen.decisions", defaultValue="")
    private String generateDecisions;
    @Parameter(property="kogito.codegen.predictions", defaultValue="")
    private String generatePredictions;
    @Parameter(property="kogito.sources.keep", defaultValue="false")
    private boolean keepSources;
    @Parameter(property="kogito.persistence.enabled", defaultValue="false")
    private boolean persistence;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources")
    private File kieSourcesDirectory;

    public void execute() throws MojoExecutionException {
        try {
            this.generateModel();
        }
        catch (IOException e) {
            throw new MojoExecutionException("An I/O error occurred", (Exception)e);
        }
    }

    private void generateModel() throws MojoExecutionException, IOException {
        boolean genRules = this.generateRules == null ? this.rulesExist() : Boolean.parseBoolean(this.generateRules);
        this.project.addCompileSourceRoot(this.generatedSources.getPath());
        this.setSystemProperties(this.properties);
        ApplicationGenerator appGen = this.createApplicationGenerator(genRules);
        List generatedFiles = appGen.generateComponents();
        for (GeneratedFile generatedFile : generatedFiles) {
            this.writeGeneratedFile(generatedFile);
        }
    }

    private boolean rulesExist() throws IOException {
        try (Stream<Path> paths = Files.walk(this.projectDir.toPath(), new FileVisitOption[0]);){
            boolean bl = paths.map(p -> p.toString().toLowerCase()).map(p -> {
                int dot = p.lastIndexOf(46);
                return dot > 0 ? p.substring(dot) : "";
            }).anyMatch(DROOLS_EXTENSIONS::contains);
            return bl;
        }
    }

    private ApplicationGenerator createApplicationGenerator(boolean generateRuleUnits) throws MojoExecutionException {
        String appPackageName = this.project.getGroupId();
        if (appPackageName.equals("org.kie.kogito")) {
            appPackageName = "org.kie.kogito.app";
        }
        ClassLoader projectClassLoader = MojoUtil.createProjectClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.project, this.outputDirectory, null);
        GeneratorContext context = GeneratorContext.ofResourcePath((File[])new File[]{this.kieSourcesDirectory});
        context.withBuildContext(this.discoverKogitoRuntimeContext(this.project));
        ApplicationGenerator appGen = new ApplicationGenerator(appPackageName, this.targetDirectory).withDependencyInjection(this.discoverDependencyInjectionAnnotator(this.project)).withClassLoader(projectClassLoader).withGeneratorContext(context);
        if (generateRuleUnits) {
            ((DeclaredTypeCodegen)appGen.withGenerator((Generator)DeclaredTypeCodegen.ofPath((Path)this.kieSourcesDirectory.toPath()))).withClassLoader(projectClassLoader);
        }
        return appGen;
    }

    private void writeGeneratedFile(GeneratedFile f) throws IOException {
        Files.write(this.pathOf(f.relativePath()), f.contents(), new OpenOption[0]);
    }

    private Path pathOf(String end) {
        Path path = Paths.get(this.generatedSources.getPath(), end);
        path.getParent().toFile().mkdirs();
        return path;
    }
}

