/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;

public final class MojoUtil {
    public static Set<URL> getProjectFiles(MavenProject mavenProject, List<InternalKieModule> kmoduleDeps) throws DependencyResolutionRequiredException, IOException {
        HashSet<URL> urls = new HashSet<URL>();
        for (String element : mavenProject.getCompileClasspathElements()) {
            urls.add(new File(element).toURI().toURL());
        }
        mavenProject.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
        for (Artifact artifact : mavenProject.getArtifacts()) {
            File file = artifact.getFile();
            if (file == null) continue;
            urls.add(file.toURI().toURL());
            KieModuleModel depModel = MojoUtil.getDependencyKieModel(file);
            if (kmoduleDeps == null || depModel == null) continue;
            ReleaseIdImpl releaseId = new ReleaseIdImpl(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            kmoduleDeps.add((InternalKieModule)new ZipKieModule((ReleaseId)releaseId, depModel, file));
        }
        return urls;
    }

    public static ClassLoader createProjectClassLoader(ClassLoader parentClassLoader, MavenProject mavenProject, File outputDirectory, List<InternalKieModule> kmoduleDeps) throws MojoExecutionException {
        try {
            Set<URL> urls = MojoUtil.getProjectFiles(mavenProject, kmoduleDeps);
            urls.add(outputDirectory.toURI().toURL());
            return URLClassLoader.newInstance(urls.toArray(new URL[0]), parentClassLoader);
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error setting up Kie ClassLoader", (Exception)e);
        }
    }

    private static KieModuleModel getDependencyKieModel(File jar) throws IOException {
        try (ZipFile zipFile = new ZipFile(jar);){
            ZipEntry zipEntry = zipFile.getEntry("META-INF/kmodule.xml");
            if (zipEntry != null) {
                KieModuleModel kieModuleModel = KieModuleModelImpl.fromXML((InputStream)zipFile.getInputStream(zipEntry));
                KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
                KieModuleModel kieModuleModel2 = kieModuleModel;
                return kieModuleModel2;
            }
        }
        return null;
    }

    private MojoUtil() {
    }
}

