/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.commons.jci.compilers.JavaCompilerSettings;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.modelcompiler.builder.GeneratedFile;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;
import org.kie.kogito.maven.plugin.AbstractKieMojo;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

@Mojo(name="process-model-classes", requiresDependencyResolution=ResolutionScope.RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class ProcessClassesMojo
extends AbstractKieMojo {
    private static final JavaCompiler JAVA_COMPILER = JavaCompilerFactory.getInstance().loadCompiler(JavaDialectConfiguration.CompilerType.NATIVE, "1.8");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(property="kogito.di.enabled", defaultValue="true")
    private boolean dependencyInjection;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            JavaCompilerSettings settings = new JavaCompilerSettings();
            ArrayList<URL> pathUrls = new ArrayList<URL>();
            for (String path : this.project.getRuntimeClasspathElements()) {
                pathUrls.add(new File(path).toURI().toURL());
                settings.addClasspath(path);
            }
            URL[] urlsForClassLoader = pathUrls.toArray(new URL[pathUrls.size()]);
            try (URLClassLoader cl = new URLClassLoader(urlsForClassLoader, Thread.currentThread().getContextClassLoader());){
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.addUrls(cl.getURLs());
                builder.addClassLoader((ClassLoader)cl);
                Reflections reflections = new Reflections((Configuration)builder);
                Set modelClasses = reflections.getSubTypesOf(Model.class);
                String appPackageName = this.project.getGroupId();
                if (appPackageName.equals("org.kie.kogito")) {
                    appPackageName = "org.kie.kogito.app";
                }
                ArrayList<String> parameters = new ArrayList<String>();
                Set classes = reflections.getSubTypesOf(ProcessInstancesFactory.class);
                if (!classes.isEmpty()) {
                    Class c = (Class)classes.iterator().next();
                    for (Type t : c.getConstructors()[0].getGenericParameterTypes()) {
                        parameters.add(t.getTypeName());
                    }
                }
                PersistenceGenerator persistenceGenerator = new PersistenceGenerator(this.targetDirectory, (Collection)modelClasses, !parameters.isEmpty(), (ProtoGenerator)new ReflectionProtoGenerator(), (ClassLoader)cl, parameters);
                persistenceGenerator.setPackageName(appPackageName);
                persistenceGenerator.setDependencyInjection(this.discoverDependencyInjectionAnnotator(this.dependencyInjection, this.project));
                Collection generatedFiles = persistenceGenerator.generate();
                MemoryFileSystem srcMfs = new MemoryFileSystem();
                MemoryFileSystem trgMfs = new MemoryFileSystem();
                String[] sources = new String[generatedFiles.size()];
                int index = 0;
                for (GeneratedFile entry : generatedFiles) {
                    String fileName = entry.getPath();
                    sources[index++] = fileName;
                    srcMfs.write(fileName, entry.getData());
                }
                if (sources.length > 0) {
                    CompilationResult result = JAVA_COMPILER.compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, (ClassLoader)cl, settings);
                    if (result.getErrors().length > 0) {
                        throw new MojoFailureException(Arrays.toString(result.getErrors()));
                    }
                    for (String fileName : trgMfs.getFileNames()) {
                        byte[] data = trgMfs.getBytes(fileName);
                        this.writeFile(fileName, data);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during processing model classes", e);
        }
    }

    private Path writeFile(String fileName, byte[] data) throws IOException {
        Path path = Paths.get(this.targetDirectory.getAbsolutePath(), "classes", fileName);
        if (!path.getParent().toFile().exists()) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Files.write(path, data, new OpenOption[0]);
        return path;
    }
}

