/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.context.SpringBootKogitoBuildContext;
import org.kie.kogito.codegen.di.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.SpringDependencyInjectionAnnotator;

public abstract class AbstractKieMojo
extends AbstractMojo {
    protected void setSystemProperties(Map<String, String> properties) {
        if (properties != null) {
            this.getLog().debug((CharSequence)("Additional system properties: " + properties));
            for (Map.Entry<String, String> property : properties.entrySet()) {
                System.setProperty(property.getKey(), property.getValue());
            }
            this.getLog().debug((CharSequence)"Configured system properties were successfully set.");
        }
    }

    protected DependencyInjectionAnnotator discoverDependencyInjectionAnnotator(boolean dependencyInjection, MavenProject project) {
        if (!dependencyInjection) {
            return null;
        }
        boolean hasSpring = project.getDependencies().stream().anyMatch(d -> d.getArtifactId().contains("spring"));
        if (hasSpring) {
            return new SpringDependencyInjectionAnnotator();
        }
        boolean hasQuarkus = project.getDependencies().stream().anyMatch(d -> d.getArtifactId().contains("quarkus"));
        if (hasQuarkus) {
            return new CDIDependencyInjectionAnnotator();
        }
        throw new IllegalStateException("Unable to find dependency injection annotator");
    }

    protected KogitoBuildContext discoverKogitoRuntimeContext(MavenProject project) {
        boolean hasSpring = project.getDependencies().stream().anyMatch(d -> d.getArtifactId().contains("spring"));
        if (hasSpring) {
            return new SpringBootKogitoBuildContext(fqcn -> this.hasClassOnClasspath(project, (String)fqcn));
        }
        boolean hasQuarkus = project.getDependencies().stream().anyMatch(d -> d.getArtifactId().contains("quarkus"));
        if (hasQuarkus) {
            return new QuarkusKogitoBuildContext(fqcn -> this.hasClassOnClasspath(project, (String)fqcn));
        }
        throw new IllegalStateException("Unable to determine Kogito runtime.");
    }

    protected boolean hasClassOnClasspath(MavenProject project, String className) {
        try {
            Set elements = project.getArtifacts();
            URL[] urls = new URL[elements.size()];
            int i = 0;
            for (Artifact artifact : elements) {
                urls[i] = artifact.getFile().toURI().toURL();
                ++i;
            }
            try (URLClassLoader cl = new URLClassLoader(urls);){
                cl.loadClass(className);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

