/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;
import org.kie.kogito.maven.plugin.AbstractKieMojo;
import org.kie.kogito.maven.plugin.util.MojoUtil;

@Mojo(name="generateModel", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class GenerateModelMojo
extends AbstractKieMojo {
    public static final List<String> DROOLS_EXTENSIONS = Arrays.asList(".drl", ".xls", ".xlsx", ".csv");
    public static final PathMatcher drlFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.drl");
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/kogito")
    private File generatedSources;
    @Parameter(property="kogito.codegen.rules", defaultValue="")
    private String generateRules;
    @Parameter(property="kogito.codegen.processes", defaultValue="")
    private String generateProcesses;
    @Parameter(property="kogito.codegen.decisions", defaultValue="")
    private String generateDecisions;
    @Parameter(property="kogito.codegen.partial", defaultValue="false")
    private boolean generatePartial;
    @Parameter(property="kogito.sources.keep", defaultValue="false")
    private boolean keepSources;
    @Parameter(property="kogito.di.enabled", defaultValue="true")
    private boolean dependencyInjection;
    @Parameter(property="kogito.persistence.enabled", defaultValue="false")
    private boolean persistence;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources")
    private File kieSourcesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.generateModel();
        }
        catch (IOException e) {
            throw new MojoExecutionException("An I/O error occurred", (Exception)e);
        }
    }

    private void generateModel() throws MojoExecutionException, IOException {
        boolean genProcesses = this.generateProcesses == null ? this.processesExist() : Boolean.parseBoolean(this.generateProcesses);
        boolean genRules = this.generateRules == null ? this.rulesExist() : Boolean.parseBoolean(this.generateRules);
        boolean genDecisions = this.generateDecisions == null ? this.decisionsExist() : Boolean.parseBoolean(this.generateDecisions);
        this.project.addCompileSourceRoot(this.generatedSources.getPath());
        this.setSystemProperties(this.properties);
        ApplicationGenerator appGen = this.createApplicationGenerator(genProcesses, genRules, genDecisions);
        Collection generatedFiles = this.generatePartial ? appGen.generateComponents() : appGen.generate();
        for (GeneratedFile generatedFile : generatedFiles) {
            this.writeGeneratedFile(generatedFile);
        }
        if (!this.keepSources) {
            this.deleteDrlFiles();
        }
    }

    private boolean decisionsExist() throws IOException {
        try (Stream<Path> paths = Files.walk(this.projectDir.toPath(), new FileVisitOption[0]);){
            boolean bl = paths.map(p -> p.toString().toLowerCase()).anyMatch(p -> p.endsWith(".dmn"));
            return bl;
        }
    }

    private boolean processesExist() throws IOException {
        try (Stream<Path> paths = Files.walk(this.projectDir.toPath(), new FileVisitOption[0]);){
            boolean bl = paths.map(p -> p.toString().toLowerCase()).anyMatch(p -> p.endsWith(".bpmn") || p.endsWith(".bpmn2"));
            return bl;
        }
    }

    private boolean rulesExist() throws IOException {
        try (Stream<Path> paths = Files.walk(this.projectDir.toPath(), new FileVisitOption[0]);){
            boolean bl = paths.map(p -> p.toString().toLowerCase()).map(p -> {
                int dot = p.lastIndexOf(46);
                return dot > 0 ? p.substring(dot) : "";
            }).anyMatch(DROOLS_EXTENSIONS::contains);
            return bl;
        }
    }

    private ApplicationGenerator createApplicationGenerator(boolean generateProcesses, boolean generateRuleUnits, boolean generateDecisions) throws IOException, MojoExecutionException {
        String appPackageName = this.project.getGroupId();
        if (appPackageName.equals("org.kie.kogito")) {
            appPackageName = "org.kie.kogito.app";
        }
        boolean usePersistence = this.persistence || this.hasClassOnClasspath(this.project, "org.kie.kogito.persistence.KogitoProcessInstancesFactory");
        boolean useMonitoring = this.hasClassOnClasspath(this.project, "org.kie.kogito.monitoring.rest.MetricsResource");
        ClassLoader projectClassLoader = MojoUtil.createProjectClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.project, this.outputDirectory, null);
        GeneratorContext context = GeneratorContext.ofResourcePath((File)this.kieSourcesDirectory);
        context.withBuildContext(this.discoverKogitoRuntimeContext(this.project));
        ApplicationGenerator appGen = new ApplicationGenerator(appPackageName, this.targetDirectory).withDependencyInjection(this.discoverDependencyInjectionAnnotator(this.dependencyInjection, this.project)).withPersistence(usePersistence).withMonitoring(useMonitoring).withClassLoader(projectClassLoader).withGeneratorContext(context);
        if (generateProcesses) {
            ((ProcessCodegen)appGen.withGenerator((Generator)ProcessCodegen.ofPath((Path)this.kieSourcesDirectory.toPath()))).withPersistence(usePersistence).withClassLoader(projectClassLoader);
        }
        if (generateRuleUnits) {
            ((IncrementalRuleCodegen)appGen.withGenerator((Generator)IncrementalRuleCodegen.ofPath((Path)this.kieSourcesDirectory.toPath()))).withKModule(this.getKModuleModel()).withClassLoader(projectClassLoader);
        }
        if (generateDecisions) {
            appGen.withGenerator((Generator)DecisionCodegen.ofPath((Path)this.kieSourcesDirectory.toPath()));
        }
        return appGen;
    }

    private KieModuleModel getKModuleModel() throws IOException {
        if (!this.project.getResources().isEmpty()) {
            Path moduleXmlPath = Paths.get(((Resource)this.project.getResources().get(0)).getDirectory(), new String[0]).resolve("META-INF/kmodule.xml");
            try {
                return KieModuleModelImpl.fromXML((InputStream)new ByteArrayInputStream(Files.readAllBytes(moduleXmlPath)));
            }
            catch (NoSuchFileException e) {
                this.getLog().debug((CharSequence)"kmodule.xml is missing. Returned the default value.", (Throwable)e);
                return new KieModuleModelImpl();
            }
        }
        this.getLog().debug((CharSequence)"kmodule.xml is missing. Returned the default value.");
        return new KieModuleModelImpl();
    }

    private void writeGeneratedFile(GeneratedFile f) throws IOException {
        Files.write(this.pathOf(f.relativePath()), f.contents(), new OpenOption[0]);
    }

    private Path pathOf(String end) {
        Path path = Paths.get(this.generatedSources.getPath(), end);
        path.getParent().toFile().mkdirs();
        return path;
    }

    private void deleteDrlFiles() throws MojoExecutionException {
        try (Stream<Path> drlFiles = Files.find(this.outputDirectory.toPath(), Integer.MAX_VALUE, (p, f) -> drlFileMatcher.matches((Path)p), new FileVisitOption[0]);){
            drlFiles.forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to find .drl files");
        }
    }
}

