/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.kie.kogito.codegen.context.JavaKogitoBuildContext;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.context.SpringBootKogitoBuildContext;

public abstract class AbstractKieMojo
extends AbstractMojo {
    protected void setSystemProperties(Map<String, String> properties) {
        if (properties != null) {
            this.getLog().debug((CharSequence)("Additional system properties: " + properties));
            for (Map.Entry<String, String> property : properties.entrySet()) {
                System.setProperty(property.getKey(), property.getValue());
            }
            this.getLog().debug((CharSequence)"Configured system properties were successfully set.");
        }
    }

    protected KogitoBuildContext discoverKogitoRuntimeContext(MavenProject project) {
        switch (this.discoverFramework(project)) {
            case QUARKUS: {
                return new QuarkusKogitoBuildContext(fqcn -> this.hasClassOnClasspath(project, (String)fqcn));
            }
            case SPRING: {
                return new SpringBootKogitoBuildContext(fqcn -> this.hasClassOnClasspath(project, (String)fqcn));
            }
        }
        return new JavaKogitoBuildContext(fqcn -> this.hasClassOnClasspath(project, (String)fqcn));
    }

    private Framework discoverFramework(MavenProject project) {
        if (this.hasDependency(project, "quarkus")) {
            return Framework.QUARKUS;
        }
        if (this.hasDependency(project, "spring")) {
            return Framework.SPRING;
        }
        return Framework.NONE;
    }

    private boolean hasDependency(MavenProject project, String dependency) {
        return project.getDependencies().stream().anyMatch(d -> d.getArtifactId().contains(dependency));
    }

    protected boolean hasClassOnClasspath(MavenProject project, String className) {
        try {
            Set elements = project.getArtifacts();
            URL[] urls = new URL[elements.size()];
            int i = 0;
            for (Artifact artifact : elements) {
                urls[i] = artifact.getFile().toURI().toURL();
                ++i;
            }
            try (URLClassLoader cl = new URLClassLoader(urls);){
                cl.loadClass(className);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static enum Framework {
        QUARKUS,
        SPRING,
        NONE;

    }
}

