/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.drools.codegen.common.GeneratedFileWriter;
import org.kie.kogito.codegen.manager.util.CodeGenManagerUtil;
import org.kie.kogito.maven.plugin.util.MojoUtil;

public abstract class AbstractKieMojo
extends AbstractMojo {
    protected static final GeneratedFileWriter.Builder GENERATED_FILE_WRITER_BUILDER = GeneratedFileWriter.builder((String)"kogito", (String)"kogito.codegen.resources.directory", (String)"kogito.codegen.sources.directory");
    @Parameter(required=true, defaultValue="${project.basedir}")
    protected File projectBaseDir;
    @Parameter
    protected Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    protected MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.sourceEncoding}")
    protected String projectSourceEncoding;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    protected File outputDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    protected File baseDir;
    @Parameter(property="kogito.codegen.persistence")
    protected boolean persistence;
    @Parameter(property="kogito.codegen.rules")
    protected String generateRules;
    @Parameter(property="kogito.codegen.processes")
    protected String generateProcesses;
    @Parameter(property="kogito.codegen.decisions")
    protected String generateDecisions;
    @Parameter(property="kogito.codegen.predictions")
    protected String generatePredictions;

    protected void setSystemProperties(Map<String, String> properties) {
        if (properties != null) {
            this.getLog().debug((CharSequence)("Additional system properties: " + properties));
            for (Map.Entry<String, String> property : properties.entrySet()) {
                System.setProperty(property.getKey(), property.getValue());
            }
            this.getLog().debug((CharSequence)"Configured system properties were successfully set.");
        }
    }

    protected ClassLoader projectClassLoader() throws MojoExecutionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return MojoUtil.createProjectClassLoader(contextClassLoader, this.project, this.outputDirectory, null);
    }

    protected CodeGenManagerUtil.Framework discoverFramework() {
        if (this.hasDependency("quarkus")) {
            return CodeGenManagerUtil.Framework.QUARKUS;
        }
        if (this.hasDependency("spring")) {
            return CodeGenManagerUtil.Framework.SPRING;
        }
        return CodeGenManagerUtil.Framework.NONE;
    }

    private boolean hasDependency(String dependency) {
        return this.project.getDependencies().stream().anyMatch(d -> d.getArtifactId().contains(dependency));
    }

    protected GeneratedFileWriter getGeneratedFileWriter() {
        return GENERATED_FILE_WRITER_BUILDER.build(Path.of(this.baseDir.getAbsolutePath(), new String[0]));
    }
}

