/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.codegen.common.GeneratedFile;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.manager.CompilerHelper;
import org.kie.kogito.codegen.manager.GenerateModelHelper;
import org.kie.kogito.codegen.manager.processes.PersistenceGenerationHelper;
import org.kie.kogito.codegen.manager.util.CodeGenManagerUtil;
import org.kie.kogito.maven.plugin.AbstractKieMojo;
import org.kie.kogito.maven.plugin.util.MojoUtil;

@Mojo(name="generateModel", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class GenerateModelMojo
extends AbstractKieMojo {
    @Parameter(property="kogito.codegen.partial", defaultValue="false")
    private boolean generatePartial;
    @Parameter(property="kogito.codegen.ondemand", defaultValue="false")
    private boolean onDemand;
    @Parameter(property="kogito.sources.keep", defaultValue="false")
    private boolean keepSources;
    @Parameter(property="kogito.jsonSchema.version", required=false)
    String schemaVersion;
    @Parameter(defaultValue="${mojoExecution}")
    private MojoExecution mojoExecution;
    @Parameter(defaultValue="3.10.2", property="version.compiler.plugin")
    private String compilerPluginVersion;
    @Parameter(defaultValue="17", property="maven.compiler.source")
    private String compilerSourceJavaVersion;
    @Parameter(defaultValue="17", property="maven.compiler.target")
    private String compilerTargetJavaVersion;
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<String, Collection<GeneratedFile>> generatedModelFiles;
        this.getLog().debug((CharSequence)("Compiler Target Java Version:" + this.compilerTargetJavaVersion));
        this.getLog().debug((CharSequence)("Compiler Source Java Version:" + this.compilerSourceJavaVersion));
        this.getLog().debug((CharSequence)("Compiler Source Encoding:" + this.projectSourceEncoding));
        this.getLog().debug((CharSequence)("Targeting directory: " + this.outputDirectory));
        boolean indexFileDirectorySet = false;
        if (this.outputDirectory == null) {
            throw new MojoExecutionException("${project.build.directory} is null");
        }
        if (System.getProperty("indexfile.directory") == null) {
            System.setProperty("indexfile.directory", this.outputDirectory.toString());
            indexFileDirectorySet = true;
        }
        this.addCompileSourceRoots();
        ClassLoader projectClassLoader = this.projectClassLoader();
        KogitoBuildContext kogitoBuildContext = this.getKogitoBuildContext(projectClassLoader);
        if (this.isOnDemand()) {
            this.getLog().info((CharSequence)"On-Demand Mode is On. Use mvn compile kogito:scaffold");
            generatedModelFiles = new HashMap<String, Collection<GeneratedFile>>();
        } else {
            generatedModelFiles = this.generateModel(kogitoBuildContext);
        }
        if (indexFileDirectorySet) {
            System.clearProperty("indexfile.directory");
        }
        this.compileAndDump(generatedModelFiles, projectClassLoader);
        Map<String, Collection<GeneratedFile>> generatedPersistenceFiles = this.generatePersistence(kogitoBuildContext, projectClassLoader);
        this.compileAndDump(generatedPersistenceFiles, projectClassLoader);
        if (!this.keepSources) {
            CodeGenManagerUtil.deleteDrlFiles((Path)this.outputDirectory.toPath());
        }
    }

    KogitoBuildContext getKogitoBuildContext(ClassLoader projectClassLoader) {
        return CodeGenManagerUtil.discoverKogitoRuntimeContext((ClassLoader)projectClassLoader, (Path)this.projectBaseDir.toPath(), (KogitoGAV)new KogitoGAV(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()), (CodeGenManagerUtil.ProjectParameters)new CodeGenManagerUtil.ProjectParameters(this.discoverFramework(), this.generateDecisions, this.generatePredictions, this.generateProcesses, this.generateRules, this.persistence), className -> MojoUtil.hasClassOnClasspath(this.project, className));
    }

    protected boolean isOnDemand() {
        return this.onDemand;
    }

    protected void addCompileSourceRoots() {
        this.project.addCompileSourceRoot(this.getGeneratedFileWriter().getScaffoldedSourcesDir().toString());
    }

    protected Map<String, Collection<GeneratedFile>> generateModel(KogitoBuildContext kogitoBuildContext) {
        this.setSystemProperties(this.properties);
        return GenerateModelHelper.generateModelFiles((KogitoBuildContext)kogitoBuildContext, (boolean)this.generatePartial);
    }

    protected Map<String, Collection<GeneratedFile>> generatePersistence(KogitoBuildContext kogitoBuildContext, ClassLoader projectClassloader) {
        return PersistenceGenerationHelper.generatePersistenceFiles((KogitoBuildContext)kogitoBuildContext, (ClassLoader)projectClassloader, (String)this.schemaVersion);
    }

    protected void compileAndDump(Map<String, Collection<GeneratedFile>> generatedFiles, ClassLoader classloader) throws MojoExecutionException {
        try {
            CompilerHelper.compileAndDumpGeneratedSources(generatedFiles.get("SOURCES"), (ClassLoader)classloader, (List)this.project.getRuntimeClasspathElements(), (File)this.baseDir, (String)this.projectSourceEncoding, (String)this.compilerSourceJavaVersion, (String)this.compilerTargetJavaVersion);
            CompilerHelper.dumpResources(generatedFiles.get("RESOURCES"), (File)this.baseDir);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during processing model classes: " + e.getMessage(), e);
        }
    }
}

