/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Iterator;
import java.util.Map;
import org.kogito.workitem.openapi.JsonNodeParser;
import org.kogito.workitem.openapi.OpenApiParameterResolver;

public class JsonNodeParameterResolver
implements OpenApiParameterResolver {
    private static final Configuration jsonPathConfig = Configuration.builder().mappingProvider((MappingProvider)new JacksonMappingProvider()).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build();
    private final JsonNode parameterDefinition;
    private final JsonNodeParser parser = new JsonNodeParser(new ObjectMapper());

    public JsonNodeParameterResolver(String parameterDefinition) {
        this.parameterDefinition = this.parser.parse(parameterDefinition);
    }

    @Override
    public JsonNode apply(Object inputModel) {
        return this.processInputModel(this.parser.parse(inputModel), this.parameterDefinition);
    }

    private JsonNode processInputModel(JsonNode inputModel, JsonNode parameterDefinition) {
        if (parameterDefinition.isArray()) {
            JsonNode processedDefinition = parameterDefinition.deepCopy();
            for (int index = 0; index < processedDefinition.size(); ++index) {
                ((ArrayNode)processedDefinition).set(index, this.processInputModel(inputModel, processedDefinition.get(index)));
            }
            return processedDefinition;
        }
        if (parameterDefinition.isValueNode()) {
            String jsonPathExpr = parameterDefinition.asText();
            if (this.parser.isJsonPath(jsonPathExpr)) {
                return (JsonNode)JsonPath.using((Configuration)jsonPathConfig).parse((Object)inputModel).read(jsonPathExpr, JsonNode.class, new Predicate[0]);
            }
            return parameterDefinition.deepCopy();
        }
        JsonNode processedDefinition = parameterDefinition.deepCopy();
        Iterator fields = processedDefinition.fields();
        while (fields.hasNext()) {
            Map.Entry jsonField = (Map.Entry)fields.next();
            ((ObjectNode)processedDefinition).replace((String)jsonField.getKey(), this.processInputModel(inputModel, (JsonNode)jsonField.getValue()));
        }
        return processedDefinition;
    }
}

