/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.kogito.workitem.openapi.JsonNodeParser;
import org.kogito.workitem.openapi.OpenApiResultHandler;

public class JsonNodeResultHandler
implements OpenApiResultHandler {
    private final JsonNodeParser parser;
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonNodeResultHandler() {
        this.parser = new JsonNodeParser(this.mapper);
    }

    @Override
    public Object apply(Object inputModel, JsonNode response) {
        return this.merge(response, this.parser.parse(inputModel));
    }

    public Object merge(JsonNode src, JsonNode dest) {
        if (dest.isArray()) {
            return ((ArrayNode)dest).add(src);
        }
        ObjectReader reader = this.mapper.readerForUpdating((Object)dest);
        try {
            if (src.isArray()) {
                ObjectNode node = (ObjectNode)reader.createObjectNode();
                node.set("response", src);
                return reader.readValue((JsonNode)node);
            }
            return reader.readValue(src);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to merge input model and JSON response: " + src, e);
        }
    }
}

