/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.IntStream;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;

public class PMMLOASUtils {
    public static final String INFINITY_SYMBOL = new String(Character.toString('\u221e').getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);

    private PMMLOASUtils() {
    }

    public static boolean isRequired(MiningField toVerify) {
        if (FIELD_USAGE_TYPE.PREDICTED.equals((Object)toVerify.getUsageType()) || FIELD_USAGE_TYPE.TARGET.equals((Object)toVerify.getUsageType())) {
            return false;
        }
        return toVerify.getMissingValueReplacement() == null;
    }

    public static boolean isPredicted(MiningField toVerify) {
        return FIELD_USAGE_TYPE.PREDICTED.equals((Object)toVerify.getUsageType()) || FIELD_USAGE_TYPE.TARGET.equals((Object)toVerify.getUsageType());
    }

    public static String getMappedType(DATA_TYPE toMap) {
        switch (toMap) {
            case DATE: 
            case DATE_TIME: 
            case STRING: {
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case INTEGER: {
                return "integer";
            }
        }
        return "number";
    }

    public static String getMappedFormat(DATA_TYPE toMap) {
        switch (toMap) {
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
        }
        return null;
    }

    public static void addIntervals(ObjectNode typeFieldNode, List<Interval> intervals) {
        if (intervals.isEmpty()) {
            return;
        }
        if (intervals.size() == 1) {
            Interval interval = intervals.get(0);
            if (interval.getLeftMargin() != null) {
                typeFieldNode.set("minimum", (JsonNode)PMMLOASUtils.getNumericNode(interval.getLeftMargin()));
            }
            if (interval.getRightMargin() != null) {
                typeFieldNode.set("maximum", (JsonNode)PMMLOASUtils.getNumericNode(interval.getRightMargin()));
            }
        } else {
            ArrayNode intervalsNode = JsonUtil.arrayNode();
            IntStream.range(0, intervals.size()).forEach(i -> {
                Interval interval = (Interval)intervals.get(i);
                String leftMargin = interval.getLeftMargin() != null ? interval.getLeftMargin().toString() : "-" + INFINITY_SYMBOL;
                String rightMargin = interval.getRightMargin() != null ? interval.getRightMargin().toString() : INFINITY_SYMBOL;
                String formattedInterval = String.format("%s %s", leftMargin, rightMargin);
                intervalsNode.add((JsonNode)new TextNode(formattedInterval));
            });
            typeFieldNode.set("intervals", (JsonNode)intervalsNode);
        }
    }

    public static void addToSetNode(String fieldName, DATA_TYPE dataType, List<String> allowedValues, ObjectNode setNode) {
        ObjectNode propertiesNode = (ObjectNode)setNode.get("properties");
        ObjectNode typeFieldNode = JsonUtil.objectNode();
        String mappedType = PMMLOASUtils.getMappedType(dataType);
        typeFieldNode.set("type", (JsonNode)new TextNode(mappedType));
        String mappedFormat = PMMLOASUtils.getMappedFormat(dataType);
        if (mappedFormat != null) {
            typeFieldNode.set("format", (JsonNode)new TextNode(mappedFormat));
        }
        propertiesNode.set(fieldName, (JsonNode)typeFieldNode);
        if (allowedValues != null && !allowedValues.isEmpty()) {
            ArrayNode availableValues = PMMLOASUtils.conditionallyCreateEnumNode(typeFieldNode);
            allowedValues.forEach(arg_0 -> ((ArrayNode)availableValues).add(arg_0));
        }
    }

    public static ArrayNode conditionallyCreateEnumNode(ObjectNode parent) {
        if (parent.get("enum") == null) {
            ArrayNode availableValues = JsonUtil.arrayNode();
            parent.set("enum", (JsonNode)availableValues);
        }
        return (ArrayNode)parent.get("enum");
    }

    public static ObjectNode createSetNodeInParent(ObjectNode parentNode, String nodeToCreate) {
        ObjectNode setNode = PMMLOASUtils.createSetNode();
        parentNode.set(nodeToCreate, (JsonNode)setNode);
        return (ObjectNode)parentNode.get(nodeToCreate);
    }

    public static ObjectNode createSetNode() {
        ObjectNode toReturn = JsonUtil.objectNode();
        toReturn.set("type", (JsonNode)new TextNode("object"));
        ObjectNode propertiesNode = JsonUtil.objectNode();
        toReturn.set("properties", (JsonNode)propertiesNode);
        return toReturn;
    }

    public static NumericNode getNumericNode(Number number) {
        String className;
        switch (className = number.getClass().getSimpleName()) {
            case "Integer": {
                return new IntNode(((Integer)number).intValue());
            }
            case "Float": {
                return new FloatNode(((Float)number).floatValue());
            }
            case "Double": {
                return new DoubleNode(((Double)number).doubleValue());
            }
            case "BigInteger": {
                return new BigIntegerNode((BigInteger)number);
            }
            case "Short": {
                return new ShortNode(((Short)number).shortValue());
            }
            case "Long": {
                return new LongNode(((Long)number).longValue());
            }
            case "BigDecimal": {
                return new DecimalNode((BigDecimal)number);
            }
        }
        throw new IllegalArgumentException("Failed to find a NumericNode for " + number.getClass());
    }
}

