/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml;

import java.util.Map;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.kogito.pmml.utils.PMMLUtils;
import org.kie.kogito.prediction.PredictionModel;
import org.kie.pmml.api.models.PMMLModel;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.evaluator.core.PMMLContextImpl;

public class PmmlPredictionModel
implements PredictionModel {
    private final PMMLRuntime pmmlRuntime;
    private final PMMLModel pmmlModel;

    public PmmlPredictionModel(PMMLRuntime pmmlRuntime, String modelName) {
        this.pmmlRuntime = pmmlRuntime;
        this.pmmlModel = (PMMLModel)pmmlRuntime.getPMMLModel(modelName).orElseThrow(() -> new IllegalStateException("PMML model '" + modelName + "' not found in the inherent PMMLRuntime."));
    }

    public PMMLContext newContext(Map<String, Object> variables) {
        PMMLRequestData pmmlRequestData = PMMLUtils.getPMMLRequestData(this.pmmlModel.getName(), variables);
        return new PMMLContextImpl(pmmlRequestData);
    }

    public PMML4Result evaluateAll(PMMLContext context) {
        return this.pmmlRuntime.evaluate(this.pmmlModel.getName(), context);
    }

    public PMMLModel getPMMLModel() {
        return this.pmmlModel;
    }
}

