/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.common.deployment;

import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.JavaCompilationProvider;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KogitoCompilationProvider
extends JavaCompilationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoCompilationProvider.class);

    public Set<String> handledSourcePaths() {
        return Collections.singleton("src" + File.separator + "main" + File.separator + "resources");
    }

    public final void compile(Set<File> filesToCompile, CompilationProvider.Context quarkusContext) {
        Path path = KogitoCompilationProvider.pathOf(quarkusContext.getOutputDirectory().getPath(), KogitoQuarkusResourceUtils.HOT_RELOAD_SUPPORT_PATH + ".java");
        try {
            Files.write(path, KogitoQuarkusResourceUtils.getHotReloadSupportSource().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        super.compile(Collections.singleton(path.toFile()), quarkusContext);
    }

    private static Path pathOf(String path, String relativePath) {
        Path p = Paths.get(path, relativePath);
        p.getParent().toFile().mkdirs();
        return p;
    }
}

