/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.common.deployment;

import java.util.HashMap;
import java.util.Map;

public class InMemoryClassLoader
extends ClassLoader {
    private Map<String, byte[]> classes = new HashMap<String, byte[]>();

    public InMemoryClassLoader(ClassLoader parent, Map<String, byte[]> classes) {
        super(parent);
        this.classes.putAll(classes);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] byteClass = this.classes.remove(name);
        if (byteClass != null) {
            return this.defineClass(name, byteClass, 0, byteClass.length);
        }
        return super.findClass(name);
    }
}

