/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.quarkus.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.jboss.logging.Logger;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.common.api.model.GeneratedClassResource;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.common.api.model.GeneratedRedirectResource;
import org.kie.efesto.common.api.model.GeneratedResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.compilationmanager.core.service.CompilationManagerImpl;
import org.kie.efesto.quarkus.deployment.EfestoGeneratedClassBuildItem;
import org.kie.efesto.runtimemanager.core.service.RuntimeManagerImpl;

public class EfestoProcessor {
    private static final Logger LOGGER = Logger.getLogger(EfestoProcessor.class);

    @BuildStep
    public List<ReflectiveClassBuildItem> reflectiveEfestoStaticClasses() {
        LOGGER.infof("reflectiveEfestoStaticClasses", new Object[0]);
        ArrayList<ReflectiveClassBuildItem> toReturn = new ArrayList<ReflectiveClassBuildItem>();
        toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{GeneratedResources.class}));
        toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{GeneratedResource.class}));
        toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{GeneratedExecutableResource.class}));
        toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{GeneratedRedirectResource.class}));
        toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{GeneratedClassResource.class}));
        toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{FRI.class}));
        toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{CompilationManagerImpl.class}));
        toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{RuntimeManagerImpl.class}));
        return toReturn;
    }

    @BuildStep
    public List<ReflectiveClassBuildItem> reflectiveEfestoGeneratedClasses(List<EfestoGeneratedClassBuildItem> efestoGeneratedClassBuildItem) {
        LOGGER.debugf("reflectiveEfestoGeneratedClasses %s", efestoGeneratedClassBuildItem);
        ArrayList<ReflectiveClassBuildItem> toReturn = new ArrayList<ReflectiveClassBuildItem>();
        efestoGeneratedClassBuildItem.forEach(generatedClassBuildItem -> {
            Map<GeneratedFileType, List<GeneratedFile>> mappedGeneratedFiles = generatedClassBuildItem.getGeneratedFiles().stream().collect(Collectors.groupingBy(GeneratedFile::type));
            List<GeneratedFile> generatedCompiledFiles = mappedGeneratedFiles.getOrDefault(GeneratedFileType.COMPILED_CLASS, Collections.emptyList());
            LOGGER.debugf("generatedCompiledFiles {}", generatedCompiledFiles);
            Collection<ReflectiveClassBuildItem> reflectiveClassBuildItems = EfestoProcessor.makeReflectiveClassBuildItems(generatedCompiledFiles);
            LOGGER.infof("reflectiveClassBuildItems {}", reflectiveClassBuildItems);
            toReturn.addAll(reflectiveClassBuildItems);
        });
        LOGGER.debugf("toReturn {}", toReturn);
        return toReturn;
    }

    @BuildStep
    public NativeImageResourceBuildItem efestoSPICompilation() {
        LOGGER.debug((Object)"efestoSPICompilation()");
        return new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.kie.efesto.compilationmanager.api.service.CompilationManager"});
    }

    @BuildStep
    public NativeImageResourceBuildItem efestoSPIRuntime() {
        LOGGER.debug((Object)"efestoSPIRuntime()");
        return new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.kie.efesto.runtimemanager.api.service.RuntimeManager"});
    }

    @BuildStep
    public NativeImageResourceBuildItem efestoSPICompilationPlugin() {
        LOGGER.debug((Object)"efestoSPICompilation()");
        return new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.kie.efesto.compilationmanager.api.service.KieCompilerService"});
    }

    @BuildStep
    public NativeImageResourceBuildItem efestoSPIRuntimePlugin() {
        LOGGER.debug((Object)"efestoSPIRuntime()");
        return new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.kie.efesto.runtimemanager.api.service.KieRuntimeService"});
    }

    private static Collection<ReflectiveClassBuildItem> makeReflectiveClassBuildItems(List<GeneratedFile> generatedCompiledFiles) {
        ArrayList<ReflectiveClassBuildItem> buildItems = new ArrayList<ReflectiveClassBuildItem>();
        for (GeneratedFile generatedFile : generatedCompiledFiles) {
            buildItems.add(new ReflectiveClassBuildItem(true, true, new String[]{generatedFile.relativePath()}));
        }
        return buildItems;
    }
}

