/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.common.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.resteasy.reactive.spi.GeneratedJaxRsResourceBuildItem;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.drools.codegen.common.DroolsModelBuildContext;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.drl.quarkus.util.deployment.DroolsQuarkusResourceUtils;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.kie.efesto.quarkus.deployment.EfestoGeneratedClassBuildItem;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.utils.ApplicationGeneratorDiscovery;
import org.kie.kogito.incubation.common.EmptyDataContext;
import org.kie.kogito.incubation.common.EmptyMetaDataContext;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.quarkus.KogitoRecorder;
import org.kie.kogito.quarkus.common.deployment.KogitoAddonsGeneratedSourcesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoAddonsPostGeneratedSourcesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoAddonsPreGeneratedSourcesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoBuildContextAttributeBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoBuildContextBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedClassesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedSourcesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusResourceUtils;
import org.kie.kogito.quarkus.common.deployment.MissingRestCapabilityException;

public class KogitoAssetsProcessor {
    private static final Logger LOGGER = Logger.getLogger(KogitoAssetsProcessor.class);
    @Inject
    ArchiveRootBuildItem root;
    @Inject
    LiveReloadBuildItem liveReload;
    @Inject
    CurateOutcomeBuildItem curateOutcomeBuildItem;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;
    @Inject
    OutputTargetBuildItem outputTargetBuildItem;

    @BuildStep
    public KogitoBuildContextBuildItem generateKogitoBuildContext(List<KogitoBuildContextAttributeBuildItem> attributes) {
        KogitoBuildContext context = KogitoQuarkusResourceUtils.kogitoBuildContext(this.outputTargetBuildItem.getOutputDirectory(), (Iterable<Path>)this.root.getResolvedPaths(), this.combinedIndexBuildItem.getIndex(), (Dependency)this.curateOutcomeBuildItem.getApplicationModel().getAppArtifact());
        attributes.forEach(attribute -> context.addContextAttribute(attribute.getName(), attribute.getValue()));
        return new KogitoBuildContextBuildItem(context);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public SyntheticBeanBuildItem runtimeConfigBuildStep(KogitoRecorder recorder) {
        ResolvedDependency appModel = this.curateOutcomeBuildItem.getApplicationModel().getAppArtifact();
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(KogitoGAV.class).scope(Singleton.class)).supplier(recorder.kogitoGAVSupplier(appModel.getGroupId(), appModel.getArtifactId(), appModel.getVersion())).done();
    }

    @BuildStep
    public KogitoGeneratedSourcesBuildItem generateSources(Capabilities capabilities, List<KogitoAddonsPreGeneratedSourcesBuildItem> extraSources, KogitoBuildContextBuildItem contextBuildItem) {
        KogitoBuildContext context = contextBuildItem.getKogitoBuildContext();
        this.validateAvailableCapabilities(context, capabilities);
        boolean indexFileDirectorySet = false;
        if (System.getProperty("indexfile.directory") == null) {
            System.setProperty("indexfile.directory", context.getAppPaths().getOutputTarget().toString());
            indexFileDirectorySet = true;
        }
        Collection<GeneratedFile> generatedFiles = this.generateFiles(context);
        if (indexFileDirectorySet) {
            System.clearProperty("indexfile.directory");
        }
        if (!this.liveReload.isLiveReload()) {
            generatedFiles.add(new GeneratedFile(GeneratedFileType.SOURCE, KogitoQuarkusResourceUtils.HOT_RELOAD_SUPPORT_PATH + ".java", KogitoQuarkusResourceUtils.getHotReloadSupportSource()));
        }
        return new KogitoGeneratedSourcesBuildItem(generatedFiles);
    }

    @BuildStep
    public List<KogitoGeneratedClassesBuildItem> generateModel(KogitoGeneratedSourcesBuildItem sources, List<KogitoAddonsPreGeneratedSourcesBuildItem> addonsPreSources, List<KogitoAddonsPostGeneratedSourcesBuildItem> addonsPostSources, KogitoBuildContextBuildItem contextBuildItem, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedJaxRsResourceBuildItem> jaxrsProducer, BuildProducer<AdditionalStaticResourceBuildItem> staticResProducer, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<GeneratedResourceBuildItem> genResBI) throws IOException {
        KogitoBuildContext context = contextBuildItem.getKogitoBuildContext();
        Collection<GeneratedFile> generatedFiles = this.collectGeneratedFiles(sources, addonsPreSources, addonsPostSources);
        Map<GeneratedFileType, List<GeneratedFile>> mappedGeneratedFiles = generatedFiles.stream().collect(Collectors.groupingBy(GeneratedFile::type));
        Collection generatedJavaSourcesFiles = mappedGeneratedFiles.entrySet().stream().filter(entry -> entry.getKey() != GeneratedFileType.COMPILED_CLASS).flatMap(generatedFileTypeListEntry -> ((List)generatedFileTypeListEntry.getValue()).stream()).collect(Collectors.toList());
        KogitoQuarkusResourceUtils.dumpFilesToDisk(context.getAppPaths(), generatedJavaSourcesFiles);
        Collection<GeneratedBeanBuildItem> generatedBeanBuildItems = this.createGeneratedBeanBuildItemsFromJavaSources(context, generatedJavaSourcesFiles, this.liveReload.isLiveReload());
        Collection<GeneratedBeanBuildItem> buildItemsFromCompiledClasses = this.createGeneratedBeanBuildItemsFromCompiledClasses(mappedGeneratedFiles.getOrDefault(GeneratedFileType.COMPILED_CLASS, Collections.emptyList()));
        generatedBeanBuildItems.addAll(buildItemsFromCompiledClasses);
        Optional<KogitoGeneratedClassesBuildItem> optionalIndex = this.indexGeneratedBeanBuildItemWithRestResources(context, generatedJavaSourcesFiles, generatedBeanBuildItems, generatedBeans, jaxrsProducer);
        this.registerDataEventsForReflection(optionalIndex.map(KogitoGeneratedClassesBuildItem::getIndexedClasses), context, reflectiveClass);
        this.registerKogitoIncubationAPI(reflectiveClass);
        KogitoQuarkusResourceUtils.registerResources(generatedFiles, staticResProducer, resource, genResBI);
        return optionalIndex.map(Collections::singletonList).orElse(Collections.emptyList());
    }

    @BuildStep
    public EfestoGeneratedClassBuildItem reflectiveEfestoGeneratedClassBuildItem(KogitoGeneratedSourcesBuildItem kogitoGeneratedSourcesBuildItem) {
        LOGGER.infof("reflectiveEfestoGeneratedClassBuildItem %s", (Object)kogitoGeneratedSourcesBuildItem);
        return new EfestoGeneratedClassBuildItem(kogitoGeneratedSourcesBuildItem.getGeneratedFiles());
    }

    private Collection<GeneratedFile> collectGeneratedFiles(KogitoGeneratedSourcesBuildItem sources, List<KogitoAddonsPreGeneratedSourcesBuildItem> preSources, List<KogitoAddonsPostGeneratedSourcesBuildItem> postSources) {
        HashMap<String, GeneratedFile> map = new HashMap<String, GeneratedFile>();
        KogitoAssetsProcessor.addGeneratedFiles(preSources, map);
        for (GeneratedFile generatedFile : sources.getGeneratedFiles()) {
            map.put(generatedFile.relativePath(), generatedFile);
        }
        KogitoAssetsProcessor.addGeneratedFiles(postSources, map);
        return map.values();
    }

    private static void addGeneratedFiles(List<? extends KogitoAddonsGeneratedSourcesBuildItem> items, Map<String, GeneratedFile> map) {
        for (KogitoAddonsGeneratedSourcesBuildItem kogitoAddonsGeneratedSourcesBuildItem : items) {
            for (GeneratedFile generatedFile : kogitoAddonsGeneratedSourcesBuildItem.getGeneratedFiles()) {
                map.put(generatedFile.relativePath(), generatedFile);
            }
        }
    }

    void validateAvailableCapabilities(KogitoBuildContext context, Capabilities capabilities) {
        boolean hasRestCapabilities;
        boolean hasOptaPlannerCapability = capabilities.isCapabilityWithPrefixPresent("org.optaplanner");
        boolean bl = hasRestCapabilities = capabilities.isPresent("io.quarkus.resteasy") && capabilities.isPresent("io.quarkus.resteasy.json.jackson") || capabilities.isPresent("io.quarkus.resteasy.reactive") && capabilities.isPresent("io.quarkus.resteasy.reactive.json.jackson");
        if (hasOptaPlannerCapability && !hasRestCapabilities && this.kogitoGenerateRest(context).isEmpty()) {
            context.setApplicationProperty("kogito.generate.rest", "false");
            LOGGER.info((Object)"Disabling Kogito REST generation because OptaPlanner extension is available, specify `kogito.generate.rest = true` to re-enable it");
        }
        if (!hasRestCapabilities && this.kogitoGenerateRest(context).orElse(true).booleanValue()) {
            throw new MissingRestCapabilityException();
        }
    }

    private Optional<Boolean> kogitoGenerateRest(KogitoBuildContext context) {
        return context.getApplicationProperty("kogito.generate.rest").map("true"::equalsIgnoreCase);
    }

    private Collection<GeneratedFile> generateFiles(KogitoBuildContext context) {
        return ApplicationGeneratorDiscovery.discover((KogitoBuildContext)context).generate();
    }

    private Collection<GeneratedBeanBuildItem> createGeneratedBeanBuildItemsFromJavaSources(KogitoBuildContext context, Collection<GeneratedFile> generatedFiles, boolean useDebugSymbols) throws IOException {
        Collection dependencies = this.curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies();
        return DroolsQuarkusResourceUtils.compileGeneratedSources((DroolsModelBuildContext)context, (Collection)dependencies, generatedFiles, (boolean)useDebugSymbols);
    }

    private Collection<GeneratedBeanBuildItem> createGeneratedBeanBuildItemsFromCompiledClasses(Collection<GeneratedFile> generatedFiles) {
        HashMap compiledClassesMap = new HashMap();
        generatedFiles.forEach(generatedFile -> compiledClassesMap.put(generatedFile.relativePath(), generatedFile.contents()));
        return DroolsQuarkusResourceUtils.makeBuildItems(compiledClassesMap);
    }

    private Optional<KogitoGeneratedClassesBuildItem> indexGeneratedBeanBuildItemWithRestResources(KogitoBuildContext context, Collection<GeneratedFile> generatedFiles, Collection<GeneratedBeanBuildItem> generatedBeanBuildItems, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedJaxRsResourceBuildItem> jaxrsProducer) throws IOException {
        generatedBeanBuildItems.forEach(arg_0 -> generatedBeans.produce(arg_0));
        Set restResourceClassNameSet = generatedFiles.stream().filter(file -> file.type().equals(Generator.REST_TYPE)).map(file -> KogitoQuarkusResourceUtils.toClassName(file.path().toString())).collect(Collectors.toSet());
        generatedBeanBuildItems.stream().filter(b -> restResourceClassNameSet.contains(b.getName())).forEach(b -> jaxrsProducer.produce((BuildItem)new GeneratedJaxRsResourceBuildItem(b.getName(), b.getData())));
        return Optional.of(this.indexBuildItems(context, generatedBeanBuildItems));
    }

    private void registerKogitoIncubationAPI(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{EmptyDataContext.class.getCanonicalName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{EmptyMetaDataContext.class.getCanonicalName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{ExtendedDataContext.class.getCanonicalName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{MapDataContext.class.getCanonicalName()}));
    }

    private void registerDataEventsForReflection(Optional<IndexView> optionalIndex, KogitoBuildContext context, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.event.AbstractDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.ProcessDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.ProcessInstanceDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.VariableInstanceDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessInstanceEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.NodeInstanceEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessErrorEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.VariableInstanceEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.UserTaskInstanceDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.UserTaskInstanceEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.UserTaskDeadlineDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.UserTaskDeadlineEventBody"}));
        if (context.getAddonsConfig().useMonitoring()) {
            this.registerMonitoringAddonClasses(reflectiveClass);
        }
        if (context.getAddonsConfig().useTracing()) {
            this.registerTracingAddonClasses(reflectiveClass);
        }
        if (context.getAddonsConfig().useExplainability()) {
            this.registerExplainabilityAddonClasses(reflectiveClass);
        }
        optionalIndex.ifPresent(index -> {
            this.addChildrenClasses((IndexView)index, "org.kie.kogito.event.AbstractDataEvent", reflectiveClass);
            this.addChildrenClasses((IndexView)index, "org.kie.kogito.services.event.ProcessDataEvent", reflectiveClass);
        });
    }

    private void registerMonitoringAddonClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.HdrHistogram.Histogram"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.HdrHistogram.ConcurrentHistogram"}));
    }

    private void registerTracingAddonClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceEventType"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceExecutionStep"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceExecutionStepType"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceHeader"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceInputValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceOutputValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceType"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceResourceId"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.message.Message"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.message.MessageLevel"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.message.MessageCategory"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.message.MessageFEELEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.message.MessageFEELEventSeverity"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.message.MessageExceptionField"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.message.MessageFEELEventSeverity"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.message.MessageFEELEventSeverity"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.message.MessageFEELEventSeverity"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceInputValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceOutputValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.typedvalue.BaseTypedValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.typedvalue.TypedValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.typedvalue.UnitValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.typedvalue.CollectionValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.typedvalue.StructureValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceExecutionStep"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.trace.TraceExecutionStepType"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.model.ModelEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.KogitoGAV"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.decision.DecisionModelType"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.decision.DecisionModelMetadata"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.message.models.DecisionMessage"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.event.model.models.DecisionModelEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.event.ModelMetadata"}));
    }

    private void registerExplainabilityAddonClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.explainability.model.PredictOutput"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.explainability.model.PredictInput"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.explainability.model.ModelIdentifier"}));
    }

    private void addChildrenClasses(IndexView index, String superClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        index.getAllKnownSubclasses(DotName.createSimple((String)superClass)).forEach(c -> reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{c.name().toString()})));
    }

    private KogitoGeneratedClassesBuildItem indexBuildItems(KogitoBuildContext context, Collection<GeneratedBeanBuildItem> buildItems) {
        Indexer kogitoIndexer = new Indexer();
        HashSet kogitoIndex = new HashSet();
        for (GeneratedBeanBuildItem generatedBeanBuildItem : buildItems) {
            IndexingUtil.indexClass((String)generatedBeanBuildItem.getName(), (Indexer)kogitoIndexer, (IndexView)this.combinedIndexBuildItem.getIndex(), kogitoIndex, (ClassLoader)context.getClassLoader(), (byte[])generatedBeanBuildItem.getData());
        }
        Map<String, byte[]> generatedClasses = buildItems.stream().collect(Collectors.toMap(GeneratedBeanBuildItem::getName, GeneratedBeanBuildItem::getData));
        return new KogitoGeneratedClassesBuildItem((IndexView)kogitoIndexer.complete(), generatedClasses);
    }
}

