/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.common.deployment;

import io.quarkus.bootstrap.model.AppDependency;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusResourceUtils;
import org.kie.memorycompiler.CompilationProblem;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryCompiler {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryCompiler.class);
    private final JavaCompiler javaCompiler;
    private final JavaCompilerSettings compilerSettings;
    private final MemoryFileSystem trgMfs = new MemoryFileSystem();

    public InMemoryCompiler(Collection<Path> classesPaths, Collection<AppDependency> userDependencies) {
        this.javaCompiler = JavaParserCompiler.getCompiler();
        this.compilerSettings = this.javaCompiler.createDefaultSettings();
        this.compilerSettings.addOption("-proc:none");
        for (Path classPath : classesPaths) {
            this.compilerSettings.addClasspath(classPath.toString());
        }
        for (AppDependency i : userDependencies) {
            this.compilerSettings.addClasspath(i.getArtifact().getPaths().getSinglePath().toAbsolutePath().toString());
        }
    }

    public CompilationResult compile(Collection<GeneratedFile> generatedFiles) {
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        String[] sources = new String[generatedFiles.size()];
        int index = 0;
        for (GeneratedFile entry : generatedFiles) {
            String generatedClassFile = entry.relativePath().replace("src/main/java/", "");
            String fileName = this.toRuntimeSource(KogitoQuarkusResourceUtils.toClassName(generatedClassFile));
            sources[index++] = fileName;
            srcMfs.write(fileName, entry.contents());
        }
        CompilationResult result = this.javaCompiler.compile(sources, (ResourceReader)srcMfs, (ResourceStore)this.trgMfs, Thread.currentThread().getContextClassLoader(), this.compilerSettings);
        if (result.getErrors().length > 0) {
            StringBuilder errorInfo = new StringBuilder();
            for (CompilationProblem compilationProblem : result.getErrors()) {
                errorInfo.append(compilationProblem.toString());
                errorInfo.append("\n");
                logger.error(compilationProblem.toString());
            }
            Arrays.stream(result.getErrors()).forEach(cp -> errorInfo.append(cp.toString()));
            throw new IllegalStateException(errorInfo.toString());
        }
        return result;
    }

    public MemoryFileSystem getTargetFileSystem() {
        return this.trgMfs;
    }

    private String toRuntimeSource(String className) {
        return "src/main/java/" + className.replace('.', '/') + ".java";
    }
}

