/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.common.deployment;

import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.JavaCompilationProvider;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.AppPaths;
import org.kie.kogito.codegen.core.ApplicationGenerator;
import org.kie.kogito.quarkus.common.deployment.KogitoCompilerException;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KogitoCompilationProvider
extends JavaCompilationProvider {
    public static final Map<Path, Path> classToSource = new ConcurrentHashMap<Path, Path>();
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoCompilationProvider.class);

    public Set<String> handledSourcePaths() {
        return Collections.singleton("src" + File.separator + "main" + File.separator + "resources");
    }

    public final void compile(Set<File> filesToCompile, CompilationProvider.Context quarkusContext) {
        try (URLClassLoader cl = new URLClassLoader(this.getClasspathUrls(quarkusContext), null);){
            File outputDirectory = quarkusContext.getOutputDirectory();
            try {
                AppPaths appPaths = AppPaths.fromProjectDir((Path)quarkusContext.getProjectDirectory().toPath());
                KogitoBuildContext context = KogitoQuarkusContextProvider.context(appPaths, cl);
                ApplicationGenerator appGen = new ApplicationGenerator(context);
                appGen.registerGeneratorIfEnabled(this.getGenerator(context, filesToCompile, quarkusContext));
                Collection generatedFiles = appGen.generate();
                HashSet<File> generatedSourceFiles = new HashSet<File>();
                for (GeneratedFile file : generatedFiles) {
                    Path path = KogitoCompilationProvider.pathOf(outputDirectory.getPath(), file.relativePath());
                    if (file.type().canHotReload()) {
                        Files.write(path, file.contents(), new OpenOption[0]);
                        if (!file.category().equals((Object)GeneratedFileType.Category.SOURCE)) continue;
                        generatedSourceFiles.add(path.toFile());
                        continue;
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Skipping file because cannot hot reload: {}", (Object)file);
                }
                super.compile(generatedSourceFiles, quarkusContext);
            }
            catch (Exception e) {
                throw new KogitoCompilerException(e);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Exception while closing URLClassLoader", e);
        }
    }

    public Path getSourcePath(Path classFilePath, Set<String> sourcePaths, String classesPath) {
        if (classToSource.containsKey(classFilePath)) {
            return classToSource.get(classFilePath);
        }
        return null;
    }

    protected abstract Generator getGenerator(KogitoBuildContext var1, Set<File> var2, CompilationProvider.Context var3);

    static Path pathOf(String path, String relativePath) {
        Path p = Paths.get(path, relativePath);
        p.getParent().toFile().mkdirs();
        return p;
    }

    private URL[] getClasspathUrls(CompilationProvider.Context context) {
        Set elements = context.getClasspath();
        URL[] urls = new URL[elements.size() + 1];
        try {
            urls[0] = context.getOutputDirectory().toURI().toURL();
            int i = 1;
            for (File artifact : elements) {
                urls[i++] = artifact.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return urls;
    }
}

