/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.common.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.AppPaths;
import org.kie.kogito.codegen.core.utils.GeneratedFileWriter;
import org.kie.kogito.quarkus.common.deployment.InMemoryCompiler;
import org.kie.kogito.quarkus.common.deployment.KogitoCompilationProvider;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedClassesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusContextProvider;
import org.kie.memorycompiler.resources.ResourceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KogitoQuarkusResourceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoQuarkusResourceUtils.class);
    private static final GeneratedFileWriter.Builder generatedFileWriterBuilder = new GeneratedFileWriter.Builder("target/classes", System.getProperty("kogito.codegen.sources.directory", "target/generated-sources/kogito/"), System.getProperty("kogito.codegen.resources.directory", "target/generated-resources/kogito/"), "target/generated-sources/kogito/");

    private KogitoQuarkusResourceUtils() {
    }

    public static KogitoBuildContext kogitoBuildContext(Iterable<Path> paths, IndexView index) {
        AppPaths appPaths = AppPaths.fromQuarkus(paths);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return KogitoQuarkusContextProvider.context(appPaths, classLoader, className -> KogitoQuarkusResourceUtils.classAvailabilityResolver(classLoader, index, className));
    }

    private static boolean classAvailabilityResolver(ClassLoader classLoader, IndexView index, String className) {
        boolean classFound;
        DotName classDotName = DotName.createSimple((String)className);
        boolean bl = classFound = !index.getAnnotations(classDotName).isEmpty() || index.getClassByName(classDotName) != null;
        if (classFound) {
            return true;
        }
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void dumpFilesToDisk(AppPaths appPaths, Collection<GeneratedFile> generatedFiles) {
        generatedFileWriterBuilder.build(appPaths.getFirstProjectPath()).writeAll(generatedFiles);
    }

    public static void registerResources(Collection<GeneratedFile> generatedFiles, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<GeneratedResourceBuildItem> genResBI) {
        for (GeneratedFile f : generatedFiles) {
            if (f.category() != GeneratedFileType.Category.RESOURCE) continue;
            genResBI.produce((BuildItem)new GeneratedResourceBuildItem(f.relativePath(), f.contents()));
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{f.relativePath()}));
        }
    }

    public static Collection<GeneratedBeanBuildItem> compileGeneratedSources(KogitoBuildContext context, List<AppDependency> dependencies, Collection<GeneratedFile> generatedFiles) throws IOException {
        Collection javaFiles = generatedFiles.stream().filter(f -> f.category() == GeneratedFileType.Category.SOURCE).collect(Collectors.toList());
        if (javaFiles.isEmpty()) {
            LOGGER.info("No Java source to compile");
            return Collections.emptyList();
        }
        InMemoryCompiler inMemoryCompiler = new InMemoryCompiler(context.getAppPaths().getClassesPaths(), dependencies);
        inMemoryCompiler.compile(javaFiles);
        return KogitoQuarkusResourceUtils.makeBuildItems(context.getAppPaths(), (ResourceReader)inMemoryCompiler.getTargetFileSystem());
    }

    public static IndexView generateAggregatedIndex(IndexView baseIndex, List<KogitoGeneratedClassesBuildItem> generatedKogitoClasses) {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        indexes.add(baseIndex);
        indexes.addAll(generatedKogitoClasses.stream().map(KogitoGeneratedClassesBuildItem::getIndexedClasses).collect(Collectors.toList()));
        return CompositeIndex.create((IndexView[])indexes.toArray(new IndexView[0]));
    }

    public static Path getTargetClassesPath(AppPaths appPaths) {
        return generatedFileWriterBuilder.build(appPaths.getFirstProjectPath()).getClassesDir();
    }

    private static Collection<GeneratedBeanBuildItem> makeBuildItems(AppPaths appPaths, ResourceReader resources) throws IOException {
        ArrayList<GeneratedBeanBuildItem> buildItems = new ArrayList<GeneratedBeanBuildItem>();
        Path location = generatedFileWriterBuilder.build(appPaths.getFirstProjectPath()).getClassesDir();
        for (String fileName : resources.getFileNames()) {
            byte[] data = resources.getBytes(fileName);
            String className = KogitoQuarkusResourceUtils.toClassName(fileName);
            buildItems.add(new GeneratedBeanBuildItem(className, data));
            Path path = KogitoQuarkusResourceUtils.pathOf(location.toString(), fileName);
            Files.write(path, data, new OpenOption[0]);
            String sourceFile = location.toString().replaceFirst("\\.class", ".java");
            if (sourceFile.contains("$")) {
                sourceFile = sourceFile.substring(0, sourceFile.indexOf("$")) + ".java";
            }
            KogitoCompilationProvider.classToSource.put(path, Paths.get(sourceFile, new String[0]));
        }
        return buildItems;
    }

    public static String toClassName(String sourceName) {
        if (sourceName.startsWith("./")) {
            sourceName = sourceName.substring(2);
        }
        if (sourceName.endsWith(".java")) {
            sourceName = sourceName.substring(0, sourceName.length() - 5);
        } else if (sourceName.endsWith(".class")) {
            sourceName = sourceName.substring(0, sourceName.length() - 6);
        }
        return sourceName.replace('/', '.');
    }

    private static Path pathOf(String location, String end) {
        Path path = Paths.get(location, end);
        path.getParent().toFile().mkdirs();
        return path;
    }
}

