/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.common.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.utils.ApplicationGeneratorDiscovery;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedClassesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusResourceUtils;

public class KogitoAssetsProcessor {
    @Inject
    ArchiveRootBuildItem root;
    @Inject
    LiveReloadBuildItem liveReload;
    @Inject
    CurateOutcomeBuildItem curateOutcomeBuildItem;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;

    @BuildStep
    public List<KogitoGeneratedClassesBuildItem> generateModel(BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<GeneratedResourceBuildItem> genResBI) throws IOException {
        KogitoBuildContext context = KogitoQuarkusResourceUtils.kogitoBuildContext((Iterable<Path>)this.root.getPaths(), this.combinedIndexBuildItem.getIndex(), this.curateOutcomeBuildItem.getEffectiveModel().getAppArtifact());
        Collection<GeneratedFile> generatedFiles = this.generateFiles(context);
        if (!this.liveReload.isLiveReload()) {
            generatedFiles.add(new GeneratedFile(GeneratedFileType.SOURCE, KogitoQuarkusResourceUtils.HOT_RELOAD_SUPPORT_PATH + ".java", KogitoQuarkusResourceUtils.getHotReloadSupportSource()));
        }
        KogitoQuarkusResourceUtils.dumpFilesToDisk(context.getAppPaths(), generatedFiles);
        Optional<KogitoGeneratedClassesBuildItem> optionalIndex = this.compileAndIndexJavaSources(context, generatedFiles, generatedBeans, this.liveReload.isLiveReload());
        this.registerDataEventsForReflection(optionalIndex.map(KogitoGeneratedClassesBuildItem::getIndexedClasses), context, reflectiveClass);
        KogitoQuarkusResourceUtils.registerResources(generatedFiles, resource, genResBI);
        return optionalIndex.map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private Collection<GeneratedFile> generateFiles(KogitoBuildContext context) {
        return ApplicationGeneratorDiscovery.discover((KogitoBuildContext)context).generate();
    }

    private Optional<KogitoGeneratedClassesBuildItem> compileAndIndexJavaSources(KogitoBuildContext context, Collection<GeneratedFile> generatedFiles, BuildProducer<GeneratedBeanBuildItem> generatedBeans, boolean useDebugSymbols) throws IOException {
        List dependencies = this.curateOutcomeBuildItem.getEffectiveModel().getUserDependencies();
        Collection<GeneratedBeanBuildItem> generatedBeanBuildItems = KogitoQuarkusResourceUtils.compileGeneratedSources(context, dependencies, generatedFiles, useDebugSymbols);
        generatedBeanBuildItems.forEach(arg_0 -> generatedBeans.produce(arg_0));
        return Optional.of(this.indexBuildItems(context, generatedBeanBuildItems));
    }

    @BuildStep
    public ReflectiveClassBuildItem reflectionJobsManagement() {
        return new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.jobs.api.Job"});
    }

    private void registerDataEventsForReflection(Optional<IndexView> optionalIndex, KogitoBuildContext context, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.event.AbstractDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.AbstractProcessDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.ProcessInstanceDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.VariableInstanceDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessInstanceEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.NodeInstanceEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessErrorEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.VariableInstanceEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.UserTaskInstanceDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.UserTaskInstanceEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.UserTaskDeadlineDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.UserTaskDeadlineEventBody"}));
        if (context.getAddonsConfig().useMonitoring()) {
            this.registerMonitoringAddonClasses(reflectiveClass);
        }
        if (context.getAddonsConfig().useTracing()) {
            this.registerTracingAddonClasses(reflectiveClass);
        }
        if (context.getAddonsConfig().useExplainability()) {
            this.registerExplainabilityAddonClasses(reflectiveClass);
        }
        optionalIndex.ifPresent(index -> {
            this.addChildrenClasses((IndexView)index, "org.kie.kogito.event.AbstractDataEvent", reflectiveClass);
            this.addChildrenClasses((IndexView)index, "org.kie.kogito.services.event.AbstractProcessDataEvent", reflectiveClass);
        });
    }

    private void registerMonitoringAddonClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.HdrHistogram.Histogram"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.HdrHistogram.ConcurrentHistogram"}));
    }

    private void registerTracingAddonClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.trace.TraceEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.trace.TraceHeader"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.trace.TraceEventType"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.trace.TraceResourceId"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.message.Message"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.message.MessageLevel"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.message.MessageCategory"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.message.MessageFEELEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.message.MessageFEELEventSeverity"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.message.MessageExceptionField"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.message.MessageFEELEventSeverity"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.message.MessageFEELEventSeverity"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.message.MessageFEELEventSeverity"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.trace.TraceInputValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.trace.TraceOutputValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.typedvalue.TypedValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.typedvalue.UnitValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.typedvalue.CollectionValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.typedvalue.StructureValue"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.trace.TraceExecutionStep"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.trace.TraceExecutionStepType"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.tracing.decision.event.model.ModelEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.KogitoGAV"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.decision.DecisionModelType"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.decision.DecisionModelMetadata"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.decision.DecisionModelMetadata$Type"}));
    }

    private void registerExplainabilityAddonClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.explainability.model.PredictOutput"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.explainability.model.PredictInput"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.explainability.model.ModelIdentifier"}));
    }

    private void addChildrenClasses(IndexView index, String superClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        index.getAllKnownSubclasses(DotName.createSimple((String)superClass)).forEach(c -> reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{c.name().toString()})));
    }

    private KogitoGeneratedClassesBuildItem indexBuildItems(KogitoBuildContext context, Collection<GeneratedBeanBuildItem> buildItems) {
        Indexer kogitoIndexer = new Indexer();
        HashSet kogitoIndex = new HashSet();
        for (GeneratedBeanBuildItem generatedBeanBuildItem : buildItems) {
            IndexingUtil.indexClass((String)generatedBeanBuildItem.getName(), (Indexer)kogitoIndexer, (IndexView)this.combinedIndexBuildItem.getIndex(), kogitoIndex, (ClassLoader)context.getClassLoader(), (byte[])generatedBeanBuildItem.getData());
        }
        Map<String, byte[]> generatedClasses = buildItems.stream().collect(Collectors.toMap(GeneratedBeanBuildItem::getName, GeneratedBeanBuildItem::getData));
        return new KogitoGeneratedClassesBuildItem((IndexView)kogitoIndexer.complete(), generatedClasses);
    }
}

