/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.common.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.codegen.common.GeneratedFileWriter;
import org.drools.quarkus.util.deployment.QuarkusAppPaths;
import org.drools.util.PortablePath;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.codegen.api.SourceFileCodegenBindNotifier;
import org.kie.kogito.codegen.api.context.KogitoApplicationPropertyProvider;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedClassesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusApplicationPropertiesProvider;
import org.kie.memorycompiler.resources.ResourceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KogitoQuarkusResourceUtils {
    static final String HOT_RELOAD_SUPPORT_PACKAGE = "org.kie.kogito.app";
    static final String HOT_RELOAD_SUPPORT_CLASS = "HotReloadSupportClass";
    static final String HOT_RELOAD_SUPPORT_FQN = "org.kie.kogito.app.HotReloadSupportClass";
    static final String HOT_RELOAD_SUPPORT_PATH = "org.kie.kogito.app.HotReloadSupportClass".replace('.', '/');
    private static boolean shouldDumpFiles = ConfigProvider.getConfig().getOptionalValue("kogito.quarkus.codegen.dumpFiles", Boolean.class).orElse(true);
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoQuarkusResourceUtils.class);
    private static final GeneratedFileWriter.Builder generatedFileWriterBuilder = GeneratedFileWriter.builder((String)"kogito", (String)"kogito.codegen.resources.directory", (String)"kogito.codegen.sources.directory");

    private KogitoQuarkusResourceUtils() {
    }

    public static KogitoBuildContext kogitoBuildContext(Iterable<Path> paths, IndexView index, Dependency appArtifact) {
        AppPaths appPaths = QuarkusAppPaths.from(paths);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        KogitoBuildContext context = QuarkusKogitoBuildContext.builder().withApplicationPropertyProvider((KogitoApplicationPropertyProvider)new KogitoQuarkusApplicationPropertiesProvider()).withClassLoader(classLoader).withClassAvailabilityResolver(className -> KogitoQuarkusResourceUtils.classAvailabilityResolver(classLoader, index, className)).withClassSubTypeAvailabilityResolver(KogitoQuarkusResourceUtils.classSubTypeAvailabilityResolver(index)).withAppPaths(appPaths).withGAV(new KogitoGAV(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getVersion())).withSourceFileProcessBindNotifier(new SourceFileCodegenBindNotifier()).build();
        if (!context.hasClassAvailable("jakarta.ws.rs.Path")) {
            LOGGER.info("Disabling REST generation because class 'jakarta.ws.rs.Path' is not available");
            context.setApplicationProperty("kogito.generate.rest", "false");
        }
        if (!context.hasClassAvailable("jakarta.inject.Inject")) {
            LOGGER.info("Disabling dependency injection generation because class 'jakarta.inject.Inject' is not available");
            context.setApplicationProperty("kogito.generate.di", "false");
        }
        return context;
    }

    private static Predicate<Class<?>> classSubTypeAvailabilityResolver(IndexView index) {
        return clazz -> index.getAllKnownImplementors(DotName.createSimple((String)clazz.getCanonicalName())).stream().anyMatch(c -> !Modifier.isInterface(c.flags()) && !Modifier.isAbstract(c.flags()));
    }

    private static boolean classAvailabilityResolver(ClassLoader classLoader, IndexView index, String className) {
        if (index != null) {
            boolean classFound;
            DotName classDotName = DotName.createSimple((String)className);
            boolean bl = classFound = !index.getAnnotations(classDotName).isEmpty() || index.getClassByName(classDotName) != null;
            if (classFound) {
                return true;
            }
        }
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void dumpFilesToDisk(AppPaths appPaths, Collection<GeneratedFile> generatedFiles) {
        if (shouldDumpFiles) {
            generatedFileWriterBuilder.build(appPaths.getFirstProjectPath()).writeAll(generatedFiles);
        }
    }

    public static void registerResources(Collection<GeneratedFile> generatedFiles, BuildProducer<AdditionalStaticResourceBuildItem> staticResProducer, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<GeneratedResourceBuildItem> genResBI) {
        for (GeneratedFile f : generatedFiles) {
            if (f.category() == GeneratedFileType.Category.INTERNAL_RESOURCE || f.category() == GeneratedFileType.Category.STATIC_HTTP_RESOURCE) {
                genResBI.produce((BuildItem)new GeneratedResourceBuildItem(f.relativePath(), f.contents(), shouldDumpFiles));
                resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{f.relativePath()}));
            }
            if (f.category() != GeneratedFileType.Category.STATIC_HTTP_RESOURCE) continue;
            String resoucePath = f.relativePath().substring("META-INF/resources/".length() - 1);
            staticResProducer.produce((BuildItem)new AdditionalStaticResourceBuildItem(resoucePath, false));
        }
    }

    public static IndexView generateAggregatedIndex(IndexView baseIndex, List<KogitoGeneratedClassesBuildItem> generatedKogitoClasses) {
        return KogitoQuarkusResourceUtils.generateAggregatedIndexNew(baseIndex, generatedKogitoClasses.stream().map(KogitoGeneratedClassesBuildItem::getIndexedClasses).collect(Collectors.toList()));
    }

    public static IndexView generateAggregatedIndexNew(IndexView baseIndex, List<IndexView> newIndexViews) {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        indexes.add(baseIndex);
        indexes.addAll(newIndexViews);
        return CompositeIndex.create(indexes);
    }

    public static Path getTargetClassesPath(AppPaths appPaths) {
        return generatedFileWriterBuilder.build(appPaths.getFirstProjectPath()).getClassesDir();
    }

    private static Collection<GeneratedBeanBuildItem> makeBuildItems(AppPaths appPaths, ResourceReader resources) throws IOException {
        ArrayList<GeneratedBeanBuildItem> buildItems = new ArrayList<GeneratedBeanBuildItem>();
        for (PortablePath path : resources.getFilePaths()) {
            byte[] data = resources.getBytes(path);
            String className = KogitoQuarkusResourceUtils.toClassName(path.asString());
            if (className.equals(HOT_RELOAD_SUPPORT_FQN)) {
                for (Path classPath : appPaths.getClassesPaths()) {
                    if (!classPath.toFile().isDirectory()) continue;
                    Files.write(KogitoQuarkusResourceUtils.pathOf(classPath.toString(), HOT_RELOAD_SUPPORT_PATH + ".class"), data, new OpenOption[0]);
                    break;
                }
            }
            buildItems.add(new GeneratedBeanBuildItem(className, data));
        }
        return buildItems;
    }

    public static String toClassName(String sourceName) {
        if (sourceName.startsWith("./")) {
            sourceName = sourceName.substring(2);
        }
        if (sourceName.endsWith(".java")) {
            sourceName = sourceName.substring(0, sourceName.length() - 5);
        } else if (sourceName.endsWith(".class")) {
            sourceName = sourceName.substring(0, sourceName.length() - 6);
        }
        return sourceName.replace('/', '.').replace('\\', '.');
    }

    private static Path pathOf(String location, String end) {
        Path path = Paths.get(location, end);
        path.getParent().toFile().mkdirs();
        return path;
    }

    static String getHotReloadSupportSource() {
        return "package org.kie.kogito.app;\n@io.quarkus.runtime.Startup()\npublic class HotReloadSupportClass {\nprivate static final String ID = \"" + UUID.randomUUID().toString() + "\";\n}";
    }
}

